/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.common.wrapper;

import fr.rakambda.fallingtree.common.config.enums.NotificationMode;
import fr.rakambda.fallingtree.common.wrapper.IComponent;
import fr.rakambda.fallingtree.common.wrapper.IItem;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import fr.rakambda.fallingtree.forge.common.wrapper.ItemStackWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.LevelWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.ServerLevelWrapper;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jspecify.annotations.NonNull;

public class PlayerWrapper
implements IPlayer {
    private final @NonNull Player raw;

    @Override
    public void sendMessage(@NonNull IComponent component, @NonNull NotificationMode mode) {
        Component text = (Component)component.getRaw();
        Player player = this.raw;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            switch (mode) {
                case CHAT: {
                    serverPlayer.sendSystemMessage(text, false);
                    break;
                }
                case ACTION_BAR: {
                    serverPlayer.sendSystemMessage(text, true);
                }
            }
        } else {
            this.raw.displayClientMessage(text, true);
        }
    }

    @Override
    public @NonNull IItemStack getMainHandItem() {
        return new ItemStackWrapper(this.raw.getMainHandItem());
    }

    @Override
    public void awardItemUsed(@NonNull IItem item) {
        this.raw.awardStat(Stats.ITEM_USED.get((Object)((Item)item.getRaw())));
    }

    @Override
    public boolean isCreative() {
        return this.raw.isCreative();
    }

    @Override
    public boolean isCrouching() {
        return this.raw.isCrouching();
    }

    @Override
    public @NonNull UUID getUUID() {
        return this.raw.getUUID();
    }

    @Override
    public @NonNull ILevel getLevel() {
        LevelWrapper levelWrapper;
        Level level = this.raw.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            levelWrapper = new ServerLevelWrapper(serverLevel);
        } else {
            levelWrapper = new LevelWrapper((LevelAccessor)this.raw.level());
        }
        return levelWrapper;
    }

    @Override
    public @NonNull Set<String> getTags() {
        return this.raw.getTags();
    }

    @Override
    public boolean addTag(@NonNull String tag) {
        return this.raw.addTag(tag);
    }

    @Override
    public boolean removeTag(@NonNull String tag) {
        return this.raw.removeTag(tag);
    }

    @Generated
    public PlayerWrapper(@NonNull Player raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    @Generated
    public String toString() {
        return "PlayerWrapper(raw=" + String.valueOf(this.getRaw()) + ")";
    }

    @Generated
    public @NonNull Player getRaw() {
        return this.raw;
    }
}

