/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.event;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.forge.common.wrapper.BlockPosWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.BlockStateWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.ServerLevelWrapper;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import org.jspecify.annotations.NonNull;

public class LeafBreakingListener {
    private final @NonNull FallingTreeCommon<Direction> mod;

    public void onServerTick(TickEvent.ServerTickEvent.Post event) {
        this.mod.getLeafBreakingHandler().onServerTick();
    }

    public void onNeighborNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockState eventState = event.getState();
            BlockPos eventPos = event.getPos();
            this.mod.getLeafBreakingHandler().onBlockUpdate(new ServerLevelWrapper(level), new BlockPosWrapper(eventPos), new BlockStateWrapper(eventState), event.getNotifiedSides().stream().map(this.mod::asDirectionCompat).collect(Collectors.toSet()));
        }
    }

    public void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            this.mod.getLeafBreakingHandler().onWorldUnload(new ServerLevelWrapper(serverLevel));
        }
    }

    @Generated
    public LeafBreakingListener(@NonNull FallingTreeCommon<Direction> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

