/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.network;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.enums.NotificationMode;
import fr.rakambda.fallingtree.common.network.ConfigurationPacket;
import fr.rakambda.fallingtree.forge.common.wrapper.PlayerWrapper;
import fr.rakambda.fallingtree.forge.network.FallingTreeConfigPacket;
import fr.rakambda.fallingtree.forge.network.ForgePacketHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;

public class PlayerJoinListener {
    @Generated
    private static final Logger log = LogManager.getLogger(PlayerJoinListener.class);
    private final @NonNull FallingTreeCommon<?> mod;

    public void onPlayerLoggedInEvent(@Nonnull PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MinecraftServer server = serverPlayer.server;
            if (Objects.nonNull(server) && server.isDedicatedServer()) {
                ConfigurationPacket packet = ConfigurationPacket.get(server.isDedicatedServer(), this.mod.getConfiguration());
                ForgePacketHandler.INSTANCE.send((Object)new FallingTreeConfigPacket(packet), PacketDistributor.PLAYER.with((Object)serverPlayer));
            } else {
                log.info("Player connected to a local world, not setting up proxy config");
            }
            if (ModList.get().isLoaded("veinminer")) {
                new PlayerWrapper(event.getEntity()).sendMessage(this.mod.translate("chat.fallingtree.veinminer_incompatibility", new Object[0]), NotificationMode.CHAT);
            }
        }
    }

    @Generated
    public PlayerJoinListener(@NonNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

