/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.api.event;

import nl.enjarai.doabarrelroll.api.event.Event;
import nl.enjarai.doabarrelroll.api.event.RollContext;
import nl.enjarai.doabarrelroll.impl.event.EventImpl;

public interface RollEvents {
    public static final Event<ShouldRollCheckEvent> SHOULD_ROLL_CHECK = new EventImpl<ShouldRollCheckEvent>();
    public static final Event<CameraModifiersEvent> EARLY_CAMERA_MODIFIERS = new EventImpl<CameraModifiersEvent>();
    public static final Event<CameraModifiersEvent> LATE_CAMERA_MODIFIERS = new EventImpl<CameraModifiersEvent>();

    public static boolean shouldRoll() {
        for (ShouldRollCheckEvent listener : SHOULD_ROLL_CHECK.getListeners()) {
            if (!listener.shouldRoll()) continue;
            return true;
        }
        return false;
    }

    public static void earlyCameraModifiers(RollContext context) {
        for (CameraModifiersEvent listener : EARLY_CAMERA_MODIFIERS.getListeners()) {
            listener.applyCameraModifiers(context);
        }
    }

    public static void lateCameraModifiers(RollContext context) {
        for (CameraModifiersEvent listener : LATE_CAMERA_MODIFIERS.getListeners()) {
            listener.applyCameraModifiers(context);
        }
    }

    public static interface ShouldRollCheckEvent {
        public boolean shouldRoll();
    }

    public static interface CameraModifiersEvent {
        public void applyCameraModifiers(RollContext var1);
    }
}

