/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.registry;

import eu.pb4.graves.model.GraveModelHandler;
import eu.pb4.graves.other.VisualGraveData;
import eu.pb4.graves.registry.AbstractGraveBlock;
import eu.pb4.graves.registry.AbstractGraveBlockEntity;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.sgui.api.gui.SignGui;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7417;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import net.minecraft.class_8828;
import net.minecraft.class_9296;

public class VisualGraveBlockEntity
extends AbstractGraveBlockEntity {
    public static class_2591<VisualGraveBlockEntity> BLOCK_ENTITY_TYPE;
    public class_2680 replacedBlockState = class_2246.field_10124.method_9564();
    private VisualGraveData visualData = VisualGraveData.DEFAULT;
    protected boolean isPlayerMade = false;
    protected class_2561[] textOverrides = null;
    private GraveModelHandler model;
    private Map<String, class_2561> cachedPlaceholders;

    public VisualGraveBlockEntity(class_2338 pos, class_2680 state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    public VisualGraveBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
    }

    public void setVisualData(VisualGraveData data, class_2680 oldBlockState) {
        this.replacedBlockState = oldBlockState;
        this.visualData = data;
        this.cachedPlaceholders = null;
        if (this.model != null) {
            this.model.setGrave(this);
        }
        this.method_5431();
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71468("BlockState", class_2487.field_25128, (Object)class_2512.method_10686((class_2680)this.replacedBlockState));
        this.visualData.writeData(view.method_71461("VisualData"));
        view.method_71472("AllowModification", this.isPlayerMade);
        if (this.textOverrides != null) {
            class_11372.class_11373 list = view.method_71467("TextOverride", class_8824.field_46597);
            for (class_2561 text : this.textOverrides) {
                list.method_71484((Object)text);
            }
        }
    }

    @Override
    public void method_11014(class_11368 view) {
        block5: {
            super.method_11014(view);
            try {
                this.visualData = VisualGraveData.readData(view.method_71434("VisualData"));
                this.replacedBlockState = class_2512.method_10681((class_7871)class_7923.field_41175, (class_2487)Objects.requireNonNull(view.method_71426("BlockState", class_2487.field_25128).orElse(new class_2487())));
                class_11368.class_11369 texts = view.method_71437("TextOverride", class_8824.field_46597);
                if (!texts.method_71453()) {
                    ArrayList<class_2561> textOverrides = new ArrayList<class_2561>();
                    for (class_2561 text : texts) {
                        class_8828.class_2585 literal;
                        class_7417 class_74172;
                        if (text.method_10855().isEmpty() && (class_74172 = text.method_10851()) instanceof class_8828.class_2585 && (literal = (class_8828.class_2585)class_74172).comp_737().length() >= 2 && literal.comp_737().charAt(0) == '\"' && literal.comp_737().charAt(literal.comp_737().length() - 1) == '\"') {
                            text = class_2561.method_43470((String)literal.comp_737().substring(1, literal.comp_737().length() - 1));
                        }
                        textOverrides.add(text);
                    }
                    this.textOverrides = textOverrides.toArray(new class_2561[0]);
                }
            }
            catch (Exception e) {
                if (this.visualData != null) break block5;
                this.visualData = VisualGraveData.DEFAULT;
            }
        }
        this.cachedPlaceholders = null;
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        VisualGraveBlockEntity self;
        block5: {
            block4: {
                if (!(t instanceof VisualGraveBlockEntity)) break block4;
                self = (VisualGraveBlockEntity)t;
                if (!world.method_8608()) break block5;
            }
            return;
        }
        if (self.model == null) {
            self.model = (GraveModelHandler)BlockBoundAttachment.get((class_1937)world, (class_2338)pos).holder();
            self.model.setGrave(self);
        }
        self.model.maybeTick(world.method_75260());
    }

    protected Map<String, class_2561> createPlaceholders() {
        Map<String, class_2561> placeholder = this.getGrave().getPlaceholders(this.field_11863.method_8503());
        if (this.textOverrides != null) {
            placeholder.put("text_1", this.textOverrides[0]);
            placeholder.put("text_2", this.textOverrides[1]);
            placeholder.put("text_3", this.textOverrides[2]);
            placeholder.put("text_4", this.textOverrides[3]);
        } else {
            placeholder.put("text_1", (class_2561)class_2561.method_43473());
            placeholder.put("text_2", (class_2561)class_2561.method_43473());
            placeholder.put("text_3", (class_2561)class_2561.method_43473());
            placeholder.put("text_4", (class_2561)class_2561.method_43473());
        }
        return placeholder;
    }

    public VisualGraveData getGrave() {
        return this.visualData;
    }

    @Override
    public VisualGraveData getClientData() {
        return this.visualData;
    }

    @Override
    public void onModelChanged(String model) {
        if (this.model != null) {
            this.model.updateModel();
        }
    }

    public void openEditScreen(class_3222 player) {
        SignGui sign = new SignGui(player){

            public void onClose() {
                VisualGraveBlockEntity.this.textOverrides = new class_2561[]{this.getLine(0), this.getLine(1), this.getLine(2), this.getLine(3)};
                VisualGraveBlockEntity.this.cachedPlaceholders = null;
                VisualGraveBlockEntity.this.method_5431();
            }
        };
        sign.setSignType(class_2246.field_10231);
        if (this.textOverrides != null) {
            int i = 0;
            for (class_2561 text : this.textOverrides) {
                sign.setLine(i, (class_2561)text.method_27661());
                if (++i == 4) break;
            }
        }
        sign.open();
    }

    @Override
    public boolean isGraveProtected() {
        return (Boolean)this.method_11010().method_11654((class_2769)AbstractGraveBlock.IS_LOCKED);
    }

    @Override
    public boolean isGraveBroken() {
        return true;
    }

    @Override
    public boolean isGravePlayerMade() {
        return this.isPlayerMade;
    }

    @Override
    public boolean isGravePaymentRequired() {
        return false;
    }

    @Override
    public class_2561 getGravePlaceholder(String id) {
        Map<String, class_2561> x = this.cachedPlaceholders;
        if (x == null) {
            this.cachedPlaceholders = x = this.createPlaceholders();
        }
        return x.getOrDefault(id, EMPTY_TEXT);
    }

    @Override
    public class_9296 getGraveGameProfile() {
        return this.getGrave().profile();
    }

    @Override
    public class_1799 getGraveSlotItem(int i) {
        return class_1799.field_8037;
    }

    @Override
    public class_1799 getGraveTaggedItem(class_2960 identifier) {
        return class_1799.field_8037;
    }

    @Override
    public class_1306 getGraveMainArm() {
        return this.getGrave().mainArm();
    }

    @Override
    public byte getGraveSkinModelLayers() {
        return this.getGrave().visualSkinModelLayers();
    }

    @Override
    public void updateModel() {
        if (this.model != null) {
            this.model.updateModel();
        }
    }
}

