/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6554;
import terrablender.api.Region;

public class RegionUtils {
    private static final List<Pair<class_6544.class_4762, class_5321<class_1959>>> VANILLA_POINTS;
    private static Map<class_5321<class_1959>, List<class_6544.class_4762>> biomeParameterPointCache;

    public static List<class_6544.class_4762> getVanillaParameterPoints(class_5321<class_1959> biome) {
        if (biomeParameterPointCache.containsKey(biome)) {
            return biomeParameterPointCache.get(biome);
        }
        List points = (List)VANILLA_POINTS.stream().filter(pair -> pair.getSecond() == biome).map(pair -> (class_6544.class_4762)pair.getFirst()).collect(ImmutableList.toImmutableList());
        biomeParameterPointCache.put(biome, points);
        return points;
    }

    static {
        biomeParameterPointCache = Maps.newHashMap();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        new class_6554().method_38185(pair -> builder.add(pair));
        VANILLA_POINTS = builder.build();
    }

    public record SearchTreeEntry<T>(Region region, class_6544.class_6548<T> tree) {
    }
}

