/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.animation;

import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.bones.AdvancedPlayerAnimBone;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import team.unnamed.mocha.MochaEngine;

public class HumanoidAnimationController
extends AnimationController {
    public static final Map<String, Vec3f> BONE_POSITIONS = Map.of("right_arm", new Vec3f(5.0f, 22.0f, 0.0f), "left_arm", new Vec3f(-5.0f, 22.0f, 0.0f), "left_leg", new Vec3f(-2.0f, 12.0f, 0.0f), "right_leg", new Vec3f(2.0f, 12.0f, 0.0f), "torso", new Vec3f(0.0f, 24.0f, 0.0f), "head", new Vec3f(0.0f, 24.0f, 0.0f), "body", new Vec3f(0.0f, 12.0f, 0.0f), "cape", new Vec3f(0.0f, 24.0f, 2.0f), "elytra", new Vec3f(0.0f, 24.0f, 2.0f));
    protected List<String> top_bones;
    private float torsoBend;
    private float torsoBendYPosMultiplier;
    private float torsoBendZPosMultiplier;
    private int torsoBendSign;

    public HumanoidAnimationController(AnimationController.AnimationStateHandler animationHandler, Function<AnimationController, MochaEngine<AnimationController>> molangRuntime) {
        this(animationHandler, BONE_POSITIONS, molangRuntime);
    }

    public HumanoidAnimationController(AnimationController.AnimationStateHandler animationHandler, Map<String, Vec3f> bonePositions, Function<AnimationController, MochaEngine<AnimationController>> molangRuntime) {
        super(animationHandler, bonePositions, molangRuntime);
    }

    @Override
    public void registerBones() {
        this.top_bones = new ArrayList<String>();
        this.registerPlayerAnimBone("body");
        this.registerTopPlayerAnimBone("right_arm");
        this.registerTopPlayerAnimBone("left_arm");
        this.registerPlayerAnimBone("right_leg");
        this.registerPlayerAnimBone("left_leg");
        this.registerTopPlayerAnimBone("head");
        this.registerPlayerAnimBone("torso");
        this.registerPlayerAnimBone("right_item");
        this.registerPlayerAnimBone("left_item");
        this.registerTopPlayerAnimBone("cape");
        this.registerPlayerAnimBone("elytra");
    }

    public void registerTopPlayerAnimBone(String name) {
        this.top_bones.add(name);
        this.registerPlayerAnimBone(name);
    }

    @Override
    public void process(AnimationData state) {
        super.process(state);
        this.torsoBend = ((AdvancedPlayerAnimBone)this.bones.get("torso")).getBend();
        float absBend = Math.abs(this.torsoBend);
        if ((double)absBend > 0.001 && this.currentAnimation != null && this.currentAnimation.animation().data().getNullable("applyBendToOtherBones") == Boolean.TRUE) {
            this.torsoBendSign = (int)Math.signum(this.torsoBend);
            this.torsoBendYPosMultiplier = (float)(-(1.0 - Math.cos(absBend)));
            this.torsoBendZPosMultiplier = (float)(1.0 - Math.sin(absBend));
        } else {
            this.torsoBendSign = 0;
        }
    }

    @Override
    public PlayerAnimBone get3DTransformRaw(@NotNull PlayerAnimBone bone) {
        bone = super.get3DTransformRaw(bone);
        String name = bone.getName();
        if (this.torsoBendSign != 0 && this.top_bones.contains(name)) {
            float offset = this.getBonePosition(name).y() - 18.0f;
            bone.rotX += this.torsoBend;
            bone.positionZ += (offset * this.torsoBendZPosMultiplier - offset) * (float)this.torsoBendSign;
            bone.positionY += offset * this.torsoBendYPosMultiplier;
        }
        return bone;
    }
}

