/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.mixin;

import java.util.Optional;
import me.cg360.mod.bridging.BridgingKeyMappings;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.building.Bridge;
import me.cg360.mod.bridging.compat.SpecialBridgingHandler;
import me.cg360.mod.bridging.compat.SpecialHandlers;
import me.cg360.mod.bridging.raytrace.BridgingStateTracker;
import me.cg360.mod.bridging.util.GameSupport;
import me.cg360.mod.bridging.util.InfoStrings;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public abstract class MinecraftClientMixin {
    @Shadow
    @Nullable
    public class_636 field_1761;
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    @Nullable
    public class_239 field_1765;
    @Shadow
    private int field_1752;
    @Shadow
    @Nullable
    public class_638 field_1687;

    @Inject(at={@At(value="TAIL")}, method={"method_1574()V"})
    public void onTick(CallbackInfo ci) {
        if (this.field_1724 != null && this.field_1724.method_24828()) {
            BridgingStateTracker.lastKnownYFrac = class_3532.method_15385((double)this.field_1724.method_23318());
        }
        if (BridgingKeyMappings.TOGGLE_BRIDGING.method_1436()) {
            BridgingMod.getConfig().toggleBridgingEnabled();
            class_2561 stateMsg = BridgingMod.getConfig().isBridgingEnabled() ? InfoStrings.ON : InfoStrings.OFF;
            class_5250 text = InfoStrings.TOGGLE_BRIDGING.method_27661().method_10852(stateMsg);
            class_310.method_1551().field_1705.method_1758((class_2561)text, false);
        }
        BridgingStateTracker.tick(this.field_1724);
    }

    @Inject(at={@At(value="HEAD")}, method={"method_1583()V"}, cancellable=true)
    public void onItemUse(CallbackInfo info) {
        boolean passesCrouchTest;
        if (!BridgingMod.getConfig().isBridgingEnabled()) {
            return;
        }
        if (this.field_1724 == null) {
            return;
        }
        if (this.field_1761 == null) {
            return;
        }
        if (this.field_1724.method_3144() || this.field_1761.method_2923()) {
            return;
        }
        if (this.field_1765 != null && this.field_1765.method_17783() != class_239.class_240.field_1333) {
            return;
        }
        boolean bl = passesCrouchTest = !BridgingMod.getConfig().shouldOnlyBridgeWhenCrouched() || this.field_1724.method_18276();
        if (!passesCrouchTest) {
            return;
        }
        class_3545<class_2338, class_2350> pair = BridgingStateTracker.getLastTickTarget();
        if (pair == null) {
            return;
        }
        for (class_1268 hand : class_1268.values()) {
            boolean stackSizeChanged;
            boolean canBePlacedInWorld;
            boolean canBePlaced;
            class_1799 itemStack = this.field_1724.method_5998(hand);
            boolean isPlaceableStack = GameSupport.isStackPlaceable(itemStack);
            if (!isPlaceableStack) {
                class_1269 usage = this.field_1761.method_2919((class_1657)this.field_1724, hand);
                if (!usage.method_23665()) continue;
                return;
            }
            class_2338 pos = (class_2338)pair.method_15442();
            class_2350 dir = ((class_2350)pair.method_15441()).method_10153();
            class_1269 blockPlaceResult = null;
            int originalStackSize = itemStack.method_7947();
            Optional<SpecialBridgingHandler> optHandler = SpecialHandlers.getSpecialHandler(itemStack);
            if (optHandler.isPresent()) {
                SpecialBridgingHandler handler = optHandler.get();
                canBePlaced = handler.canBePlaced(itemStack);
                canBePlacedInWorld = handler.canBePlacedInWorld(itemStack, (class_1657)this.field_1724, (class_1937)this.field_1687, pos, dir);
                if (!canBePlaced || !canBePlacedInWorld) continue;
                blockPlaceResult = optHandler.get().place();
            } else {
                canBePlaced = GameSupport.passesDefaultPlacementCheck(itemStack);
                canBePlacedInWorld = this.field_1724.method_7343(pos, dir, itemStack);
            }
            if (blockPlaceResult == null) {
                if (!canBePlaced || !canBePlacedInWorld) continue;
                class_3965 blockHitResult = this.bridgingmod$getFinalPlaceAssistTarget(itemStack, dir, pos, optHandler.orElse(null));
                blockPlaceResult = this.field_1761.method_2896(this.field_1724, hand, blockHitResult);
            }
            if (!(blockPlaceResult instanceof class_1269.class_9860)) continue;
            class_1269.class_9860 successResult = (class_1269.class_9860)blockPlaceResult;
            this.field_1752 = Math.max(0, BridgingMod.getConfig().getDelayPostBridging());
            info.cancel();
            if (successResult.comp_2909() != class_1269.class_9861.field_52427) {
                return;
            }
            this.field_1724.method_6104(hand);
            boolean bl2 = stackSizeChanged = itemStack.method_7947() != originalStackSize || this.field_1724.method_56992();
            if (stackSizeChanged && !itemStack.method_7960()) {
                class_310.method_1551().field_1773.field_4012.method_3215(hand);
            }
            return;
        }
    }

    @Unique
    @NotNull
    private class_3965 bridgingmod$getFinalPlaceAssistTarget(class_1799 heldItem, class_2350 dir, class_2338 pos, SpecialBridgingHandler specialHandler) {
        class_3965 customPlaceAssistTarget;
        if (specialHandler != null && (customPlaceAssistTarget = specialHandler.generatePlacementTarget(heldItem, (class_1657)this.field_1724, (class_1937)this.field_1687, dir, pos)) != null) {
            return customPlaceAssistTarget;
        }
        return Bridge.getDefaultPlaceAssistTarget(heldItem, (class_1937)this.field_1687, dir, pos);
    }
}

