/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin.fabric;

import com.supermartijn642.fusion.resources.FusionPackMetadata;
import com.supermartijn642.fusion.resources.FusionPackMetadataSection;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.impl.resource.pack.ModNioPackResources;
import net.minecraft.class_3255;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ModNioPackResources.class})
public class ModNioPackResourcesMixin {
    @Shadow(remap=false)
    private static boolean exists(Path path) {
        throw new AssertionError();
    }

    @ModifyVariable(method={"create"}, at=@At(value="STORE"), ordinal=0)
    private static List<Path> create(List<Path> rootPaths) {
        ArrayList<Path> newRootPaths = null;
        for (Path rootPath : rootPaths) {
            Path overridesPath;
            block10: {
                Path metaPath = rootPath.resolve("pack.mcmeta").toAbsolutePath().normalize();
                if (!ModNioPackResourcesMixin.exists(metaPath)) continue;
                overridesPath = null;
                try (InputStream stream = Files.newInputStream(metaPath, new OpenOption[0]);){
                    FusionPackMetadata metadata = (FusionPackMetadata)class_3255.method_14392(FusionPackMetadataSection.TYPE, (InputStream)stream, null);
                    if (metadata == null || !metadata.hasOverridesFolder()) break block10;
                    overridesPath = rootPath.resolve(metadata.getOverridesFolder());
                }
                catch (Exception ignore) {
                    continue;
                }
            }
            if (overridesPath == null) continue;
            if (newRootPaths == null) {
                newRootPaths = new ArrayList<Path>(rootPaths);
            }
            newRootPaths.add(overridesPath);
        }
        return newRootPaths == null ? rootPaths : newRootPaths;
    }
}

