/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.model.modifiers.block.BlockModelModifierBakedModel;
import com.supermartijn642.fusion.model.modifiers.block.PaneCullingBakedModel;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_10526;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_10893;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4309;
import net.minecraft.class_7654;
import net.minecraft.class_7775;
import net.minecraft.class_7923;
import net.minecraft.class_813;

public class BlockModelModifierReloadListener {
    private static final String LOCATION = "fusion/model_modifiers/blocks";
    private static final class_7654 ID_CONVERTER = class_7654.method_45114((String)"fusion/model_modifiers/blocks");
    public static final BlockModelModifierReloadListener INSTANCE = new BlockModelModifierReloadListener();
    private final Map<class_2680, Properties> models = new HashMap<class_2680, Properties>();

    private BlockModelModifierReloadListener() {
    }

    public void registerOverlays(class_10526.class_10103 resolver) {
        HashSet<class_2960> models = new HashSet<class_2960>();
        for (Properties properties : this.models.values()) {
            models.addAll(properties.appendModels);
        }
        models.forEach(arg_0 -> ((class_10526.class_10103)resolver).markDependency(arg_0));
    }

    public void applyOverlays(class_1088.class_10524 results, class_1088.class_7778 resolver) {
        Map bakedModels = results.comp_3430();
        for (Map.Entry<class_2680, Properties> entry : this.models.entrySet()) {
            class_2680 target = entry.getKey();
            class_1087 targetModel = (class_1087)bakedModels.get(target);
            if (targetModel == null) continue;
            Properties properties = entry.getValue();
            List<class_2960> overlays = properties.appendModels;
            List<class_1087> overlayModels = overlays.stream().map(l -> new class_10893.class_10894(new class_813(l, class_813.class_10803.field_56935)).method_68521((class_7775)resolver)).toList();
            Object model = new BlockModelModifierBakedModel(targetModel, overlayModels, properties.showBreakingOverlay);
            if (properties.paneCullingFix) {
                model = new PaneCullingBakedModel((class_1087)model);
            }
            bakedModels.put(target, model);
        }
    }

    public void reload(class_3300 resourceManager) {
        this.models.clear();
        HashMap resources = new HashMap();
        class_4309.method_51148((class_3300)resourceManager, (class_7654)ID_CONVERTER, (DynamicOps)JsonOps.INSTANCE, (Codec)new Codec<JsonElement>(this){

            public <T> DataResult<Pair<JsonElement, T>> decode(DynamicOps<T> ops, T input) {
                return DataResult.success((Object)Pair.of((Object)((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)), input));
            }

            public <T> DataResult<T> encode(JsonElement input, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, input));
            }
        }, resources);
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new IllegalArgumentException("Block model overlay '" + String.valueOf(location) + "' must contain a json object!");
            }
            JsonObject json = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                this.parseResource(json);
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse block model overlay '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    private void parseResource(JsonObject json) {
        if (!json.has("targets") || !json.get("targets").isJsonArray()) {
            throw new JsonParseException("Model overlay must have array property 'targets'!");
        }
        JsonArray targetsJson = json.getAsJsonArray("targets");
        HashSet targets = new HashSet();
        for (JsonElement element : targetsJson) {
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Target must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                class_2960 identifier = class_2960.method_60654((String)element.getAsString());
                Optional block = class_7923.field_41175.method_17966(identifier);
                if (block.isEmpty()) {
                    throw new JsonParseException("Could not find a block for model overlay target '" + String.valueOf(identifier) + "'!");
                }
                targets.addAll(((class_2248)block.get()).method_9595().method_11662());
                continue;
            }
            if (element.isJsonObject()) {
                this.parseTarget(element.getAsJsonObject()).forEach(targets::add);
                continue;
            }
            throw new JsonParseException("Model overlay 'targets' array must only contain objects and strings!");
        }
        if (targets.isEmpty()) {
            return;
        }
        if (!json.has("append") && !json.has("pane_culling_fix")) {
            throw new JsonParseException("Must have either 'append' or 'pane_culling_fix' property!");
        }
        LinkedHashSet<class_2960> models = new LinkedHashSet<class_2960>();
        if (json.has("append")) {
            if (!json.get("append").isJsonArray()) {
                throw new JsonParseException("Property 'append' must be an array!");
            }
            JsonArray appendJson = json.getAsJsonArray("append");
            for (JsonElement element : appendJson) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array property 'append' must only contain strings!");
                }
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Model must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                models.add(class_2960.method_60654((String)element.getAsString()));
            }
        }
        Boolean showBreakingOverlay = null;
        if (json.has("show_breaking_overlay")) {
            if (!json.get("show_breaking_overlay").isJsonPrimitive() || !json.get("show_breaking_overlay").getAsJsonPrimitive().isBoolean()) {
                throw new JsonParseException("Property 'show_breaking_overlay' must be a boolean!");
            }
            showBreakingOverlay = json.get("show_breaking_overlay").getAsBoolean();
        }
        Boolean paneCullingFix = null;
        if (json.has("pane_culling_fix")) {
            if (!json.get("pane_culling_fix").isJsonPrimitive() || !json.getAsJsonPrimitive("pane_culling_fix").isBoolean()) {
                throw new JsonParseException("Property 'pane_culling_fix' must be a boolean!");
            }
            paneCullingFix = json.get("pane_culling_fix").getAsBoolean();
        }
        if (models.isEmpty() && paneCullingFix != Boolean.TRUE) {
            return;
        }
        for (class_2680 target : targets) {
            Properties properties = this.models.computeIfAbsent(target, t -> new Properties());
            properties.appendModels.addAll(models);
            if (showBreakingOverlay != null) {
                properties.showBreakingOverlay = showBreakingOverlay;
            }
            if (paneCullingFix == null) continue;
            properties.paneCullingFix = paneCullingFix;
        }
    }

    private Stream<class_2680> parseTarget(JsonObject json) {
        if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
            throw new JsonParseException("Target must have string property 'block'!");
        }
        if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
            throw new JsonParseException("Target property 'block' must be a valid identifier, not '" + json.get("block").getAsString() + "'!!");
        }
        class_2960 identifier = class_2960.method_60654((String)json.get("block").getAsString());
        Optional optional = class_7923.field_41175.method_17966(identifier);
        if (optional.isEmpty()) {
            throw new JsonParseException("Could not find a block for model overlay target '" + String.valueOf(identifier) + "'!");
        }
        class_2248 block = (class_2248)optional.get();
        HashMap<class_2769, ImmutableSet> properties = new HashMap<class_2769, ImmutableSet>();
        if (!json.has("properties") || !json.get("properties").isJsonObject()) {
            throw new JsonParseException("Match block predicate must have object property 'properties'!");
        }
        if (json.getAsJsonObject("properties").isEmpty()) {
            throw new JsonParseException("At least one property must be specified for match state predicate!");
        }
        for (Map.Entry entry : json.getAsJsonObject("properties").entrySet()) {
            class_2769 property = block.method_9595().method_11663((String)entry.getKey());
            if (property == null) {
                throw new JsonParseException("Block '" + String.valueOf(identifier) + "' does not have a property named '" + (String)entry.getKey() + "'!");
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                Optional value = property.method_11900(((JsonElement)entry.getValue()).getAsString());
                if (value.isEmpty()) {
                    throw new JsonParseException("Unknown value '" + ((JsonElement)entry.getValue()).getAsString() + "' for property '" + property.method_11899() + "' in block '" + String.valueOf(identifier) + "'!");
                }
                builder.add(value.get());
            } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                if (((JsonElement)entry.getValue()).getAsJsonArray().isEmpty()) {
                    throw new JsonParseException("Valid values for property '" + property.method_11899() + "' cannot be empty!");
                }
                for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                        throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                    }
                    Optional value = property.method_11900(element.getAsString());
                    if (value.isEmpty()) {
                        throw new JsonParseException("Unknown value '" + element.getAsString() + "' for property '" + property.method_11899() + "' in block '" + String.valueOf(identifier) + "'!");
                    }
                    builder.add(value.get());
                }
            } else {
                throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
            }
            properties.put(property, builder.build());
        }
        Stream<Object> states = Stream.of((class_2680)block.method_9595().method_11664());
        for (class_2769 property : block.method_9595().method_11659()) {
            if (properties.containsKey(property)) {
                Set values = (Set)properties.get(property);
                states = states.flatMap(state -> values.stream().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value)));
                continue;
            }
            states = states.flatMap(state -> property.method_30043().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value.comp_71())));
        }
        return states;
    }

    private static <T extends Comparable<T>> class_2680 stateWithValue(class_2680 state, class_2769<?> property, Object value) {
        return (class_2680)state.method_11657(property, (Comparable)value);
    }

    private static class Properties {
        final List<class_2960> appendModels = new ArrayList<class_2960>();
        boolean paneCullingFix;
        boolean showBreakingOverlay = true;

        private Properties() {
        }
    }
}

