/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.a5b84.helditeminfo.HeldItemInfo;
import java.util.Optional;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_10712;
import net.minecraft.class_11362;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_8942;

public class HeldItemInfoDebugCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"helditeminfo").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"give").executes(HeldItemInfoDebugCommand::executeGive)).then(ClientCommandManager.argument((String)"row", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(HeldItemInfoDebugCommand::executeGiveRow))).then(ClientCommandManager.literal((String)"gen").executes(HeldItemInfoDebugCommand::executeGenerate)))).then(ClientCommandManager.literal((String)"item").executes(HeldItemInfoDebugCommand::executeShowItem))).then(ClientCommandManager.literal((String)"trace").executes(HeldItemInfoDebugCommand::executeTraceTooltipLines)));
    }

    private static int executeGive(CommandContext<FabricClientCommandSource> context) {
        return HeldItemInfoDebugCommand.executeGive(context, 0, Integer.MAX_VALUE);
    }

    private static int executeGiveRow(CommandContext<FabricClientCommandSource> context) {
        int row = IntegerArgumentType.getInteger(context, (String)"row");
        int start = (row - 1) * 9;
        return HeldItemInfoDebugCommand.executeGive(context, start, start + 9);
    }

    private static int executeGive(CommandContext<FabricClientCommandSource> context, int start, int end) {
        String[] items = new String[]{"minecraft:diamond_sword[minecraft:enchantments={\"minecraft:sharpness\": 5, \"minecraft:looting\": 3, \"minecraft:fire_aspect\": 2}]", "minecraft:potion[minecraft:potion_contents={potion: \"minecraft:strong_turtle_master\"}]", "minecraft:ominous_bottle", "minecraft:shulker_box[minecraft:container=[{item: {count: 32, id: \"minecraft:redstone_ore\"}, slot: 0}, {item: {count: 32, id: \"minecraft:stone\"}, slot: 1}, {item: {components: {\"minecraft:item_name\": {extra: [{color: \"#FF00FF\", underlined: 1b, text: \"def\"}], text: \"abc \"}}, count: 1, id: \"minecraft:golden_sword\"}, slot: 2}, {item: {count: 32, id: \"minecraft:stone\"}, slot: 3}, {item: {count: 64, id: \"minecraft:stone\"}, slot: 4}, {item: {count: 64, id: \"minecraft:redstone_ore\"}, slot: 5}, {item: {count: 64, id: \"minecraft:stone\"}, slot: 6}, {item: {count: 64, id: \"minecraft:stone\"}, slot: 7}, {item: {count: 64, id: \"minecraft:stone\"}, slot: 8}, {item: {count: 64, id: \"minecraft:stone\"}, slot: 9}, {item: {components: {\"minecraft:enchantments\": {\"minecraft:sharpness\": 5}}, count: 1, id: \"minecraft:iron_sword\"}, slot: 10}, {item: {count: 64, id: \"minecraft:stone\"}, slot: 11}, {item: {components: {\"minecraft:enchantments\": {\"minecraft:sharpness\": 5}}, count: 1, id: \"minecraft:iron_sword\"}, slot: 12}, {item: {count: 64, id: \"minecraft:stone\"}, slot: 13}, {item: {count: 32, id: \"minecraft:stone\"}, slot: 14}, {item: {count: 64, id: \"minecraft:redstone_ore\"}, slot: 18}, {item: {count: 64, id: \"minecraft:stone\"}, slot: 19}, {item: {count: 64, id: \"minecraft:stone\"}, slot: 20}, {item: {components: {\"minecraft:item_name\": {extra: [{color: \"#FF00FF\", underlined: 1b, text: \"def\"}], text: \"abc \"}}, count: 1, id: \"minecraft:golden_sword\"}, slot: 21}, {item: {count: 64, id: \"minecraft:diamond_ore\"}, slot: 22}, {item: {count: 64, id: \"minecraft:diamond_ore\"}, slot: 23}, {item: {count: 64, id: \"minecraft:diamond_ore\"}, slot: 24}]]", "minecraft:chiseled_bookshelf[minecraft:container=[{item: {count: 1, id: \"minecraft:book\"}, slot: 0}, {item: {count: 1, id: \"minecraft:book\"}, slot: 2}, {item: {count: 1, id: \"minecraft:book\"}, slot: 4}]]", "minecraft:bundle[minecraft:bundle_contents=[{count: 3, id: \"minecraft:gold_block\"}, {count: 2, id: \"minecraft:iron_block\"}]]", "minecraft:suspicious_sand[minecraft:block_entity_data={id: \"brushable_block\", item: {count: 2, id: \"minecraft:gold_block\"}}]", "minecraft:firework_rocket[minecraft:fireworks={explosions: [{fade_colors: [I; 11743532], shape: \"large_ball\", colors: [I; 14188952]}], flight_duration: 2b}]", "minecraft:command_block[minecraft:block_entity_data={conditionMet: 0b, auto: 0b, powered: 0b, Command: \"say \u30cf\u30ed\u30fc\u30a8\u30d6\u30ea\u30cb\u30e3\u30f3 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\", id: \"minecraft:command_block\", SuccessCount: 0, TrackOutput: 1b, UpdateLastExecution: 1b}]", "minecraft:bee_nest[minecraft:bees=[{ticks_in_hive: 0, entity_data: {id: \"minecraft:bee\"}, min_ticks_in_hive: 200}],minecraft:block_state={honey_level: \"3\"}]", "minecraft:crossbow[minecraft:charged_projectiles=[{count: 1, components: {\"minecraft:intangible_projectile\": {}}, id: \"minecraft:spectral_arrow\"}]]", "minecraft:book[minecraft:lore=[{color: \"blue\", extra: [\"consectetur adipiscing elit.\"], text: \"Lorem ipsum dolor sit amet, \"}, {text: \"Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\", italic: 1b}],minecraft:unbreakable={}]", "minecraft:acacia_sign[minecraft:block_entity_data={back_text: {has_glowing_text: 1b, color: \"yellow\", messages: [\"\", \"back line 2\", \"\", {color: \"gold\", text: \"back line 4\"}]}, is_waxed: 0b, id: \"minecraft:sign\", front_text: {has_glowing_text: 0b, color: \"black\", messages: [\"front line 1\", \"\", {extra: [{color: \"light_purple\", bold: 1b, text: \"3\"}], text: \"front line \"}, \"\"]}}]", "minecraft:music_disc_13", "minecraft:disc_fragment_5", "minecraft:painting[minecraft:painting/variant=\"minecraft:kebab\"]", "minecraft:goat_horn[minecraft:instrument=\"minecraft:ponder_goat_horn\"]", "minecraft:written_book[minecraft:written_book_content={generation: 3, title: {raw: \"Title title\"}, author: \"@me\"}]", "minecraft:filled_map[minecraft:map_id=0]", "minecraft:tropical_fish_bucket[minecraft:tropical_fish/pattern_color=\"blue\",minecraft:tropical_fish/base_color=\"red\",minecraft:tropical_fish/pattern=\"flopper\"]", "minecraft:spawner[minecraft:block_entity_data={SpawnData: {entity: {id: \"minecraft:pig\"}}, id: \"minecraft:mob_spawner\"}]", "minecraft:trial_spawner[block_entity_data={id:\"minecraft:trial_spawner\",spawn_data:{entity:{id:\"minecraft:pig\"}}}]"};
        class_634 networkHandler = ((FabricClientCommandSource)context.getSource()).getPlayer().field_3944;
        end = Math.min(end, items.length);
        for (int i = start; i < end; ++i) {
            networkHandler.method_45730("give @s " + items[i]);
        }
        return 1;
    }

    private static int executeGenerate(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_746 player = source.getPlayer();
        class_1799 stack = player.method_6047();
        class_2487 nbt = HeldItemInfoDebugCommand.toNbt(stack, (class_7225.class_7874)player.method_56673());
        class_5250 result = class_2561.method_43470((String)((String)nbt.method_10558("id").orElseThrow()));
        Optional components = nbt.method_10562("components");
        if (components.isPresent()) {
            boolean isFirstComponent = true;
            result.method_27693("[");
            for (String key : ((class_2487)components.get()).method_10541()) {
                class_2520 component = ((class_2487)components.get()).method_10580(key);
                result.method_27693((isFirstComponent ? "" : ",") + key + "=");
                result.method_10852(class_2512.method_32270((class_2520)component));
                isFirstComponent = false;
            }
            result.method_27693("]");
        }
        source.sendFeedback((class_2561)result);
        return 1;
    }

    private static class_2487 toNbt(class_1799 stack, class_7225.class_7874 registries) {
        try (class_8942.class_11340 reporter = new class_8942.class_11340(HeldItemInfo.LOGGER);){
            class_11362 view = class_11362.method_71459((class_8942)reporter, (class_7225.class_7874)registries);
            view.method_71468("stack", class_1799.field_24671, (Object)stack);
            class_2487 class_24872 = (class_2487)view.method_71475().method_10562("stack").orElseThrow();
            return class_24872;
        }
    }

    private static int executeShowItem(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_1792 item = source.getPlayer().method_6047().method_7909();
        source.sendFeedback((class_2561)class_2561.method_43470((String)item.getClass().getName()));
        return 1;
    }

    private static int executeTraceTooltipLines(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_1799 stack = source.getPlayer().method_6047();
        stack.method_67194(class_1792.class_9635.method_59528((class_1937)source.getWorld()), class_10712.field_56318, (class_1657)source.getPlayer(), (class_1836)class_1836.field_41070, line -> {
            StackTraceElement element;
            String className;
            source.sendFeedback(line);
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            String endClassName = HeldItemInfoDebugCommand.class.getName();
            for (int i = 2; i < stackTraceElements.length && !(className = (element = stackTraceElements[i]).getClassName()).equals(endClassName); ++i) {
                className = className.substring(className.lastIndexOf(46) + 1);
                source.sendFeedback((class_2561)class_2561.method_43470((String)("  at " + className + "." + element.getMethodName() + ":" + element.getLineNumber())));
            }
        });
        return 1;
    }
}

