/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo.mixin;

import io.github.a5b84.helditeminfo.Appenders;
import io.github.a5b84.helditeminfo.ContainerContentAppender;
import io.github.a5b84.helditeminfo.HeldItemInfo;
import io.github.a5b84.helditeminfo.TooltipAppender;
import io.github.a5b84.helditeminfo.TooltipBuilder;
import io.github.a5b84.helditeminfo.TooltipLine;
import io.github.a5b84.helditeminfo.Util;
import io.github.a5b84.helditeminfo.config.HeldItemInfoConfig;
import io.github.a5b84.helditeminfo.mixin.InGameHudAccessor;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_9334;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public abstract class InGameHudMixin {
    @Unique
    private static final int VANILLA_TOOLTIP_Y_OFFSET = 29 + 2 * InGameHudAccessor.getLineHeight() + 1 + 9;
    @Shadow
    @Final
    private class_310 field_2035;
    @Shadow
    private int field_2040;
    @Shadow
    private class_1799 field_2031;
    @Shadow
    private int field_2014;
    @Shadow
    private int field_2033;
    @Unique
    private List<TooltipLine> tooltip = Collections.emptyList();
    @Unique
    private class_1799 stackBeforeTick;
    @Unique
    private int maxWidth = -1;
    @Unique
    private int lastTooltipY;

    @Shadow
    @Nullable
    protected abstract class_1657 method_1737();

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onBeforeRender(CallbackInfo ci) {
        this.lastTooltipY = -1;
    }

    @Redirect(method={"renderHeldItemTooltip"}, at=@At(value="INVOKE", target="net/minecraft/client/gui/DrawContext.drawTextWithBackground(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;IIII)V"))
    private void drawTextProxy(class_332 context, class_327 textRenderer, class_2561 text, int _x, int y, int width, int color) {
        class_1657 player;
        int lineHeight = HeldItemInfo.config.lineHeight();
        y -= (int)(((float)lineHeight - HeldItemInfo.config.offsetPerExtraLine()) * (float)(this.tooltip.size() - 1)) + HeldItemInfo.config.verticalOffset();
        if (HeldItemInfo.config.showName() && this.tooltip.size() > 1) {
            y -= HeldItemInfo.config.itemNameSpacing();
        }
        if (HeldItemInfo.config.preventOverlap() && this.field_2035.field_1761.method_2908() && (player = this.method_1737()) != null) {
            y -= this.getHealthBarsTotalHeight(player) - InGameHudAccessor.getLineHeight();
        }
        this.lastTooltipY = y;
        this.drawBackground(context, y);
        int i = 0;
        for (TooltipLine line : this.tooltip) {
            int x = (context.method_51421() - line.width) / 2;
            context.method_27535(textRenderer, line.text, x, y, color);
            y += lineHeight;
            if (i == 0 && HeldItemInfo.config.showName()) {
                y += HeldItemInfo.config.itemNameSpacing();
            }
            ++i;
        }
    }

    @Unique
    private int getHealthBarsTotalHeight(class_1657 player) {
        float totalHalfHearts = Math.max((float)player.method_45325(class_5134.field_23716), (float)Math.max(this.field_2014, this.field_2033)) + (float)class_3532.method_15386((float)player.method_6067());
        int rows = class_3532.method_15386((float)(totalHalfHearts / 2.0f / (float)InGameHudAccessor.getNumHeartsPerRow()));
        int lineHeight = InGameHudAccessor.getLineHeight();
        int rowOffset = Math.max(lineHeight - (rows - 2), 3);
        return lineHeight + (rows - 1) * rowOffset;
    }

    @Unique
    private void drawBackground(class_332 context, int y) {
        int backgroundColor = this.getBackgroundColor();
        if (class_9848.method_61320((int)backgroundColor) != 0) {
            int scaledWidth = context.method_51421();
            int height = HeldItemInfo.config.lineHeight() * this.tooltip.size();
            if (HeldItemInfo.config.showName() && this.tooltip.size() > 1) {
                height += HeldItemInfo.config.itemNameSpacing();
            }
            int padding = 2;
            this.computeMaxWidth();
            context.method_25294((scaledWidth - this.maxWidth) / 2 - padding, y - padding, (scaledWidth + this.maxWidth) / 2 + padding, y + height + padding, backgroundColor);
        }
    }

    @Unique
    private int getBackgroundColor() {
        return switch (HeldItemInfo.config.tooltipBackgroundVisibility()) {
            default -> throw new MatchException(null, null);
            case HeldItemInfoConfig.TextBackgroundVisiblity.VANILLA -> this.field_2035.field_1690.method_19344(0);
            case HeldItemInfoConfig.TextBackgroundVisiblity.ALWAYS -> class_9848.method_61318((float)((Double)this.field_2035.field_1690.method_42550().method_41753()).floatValue(), (float)0.0f, (float)0.0f, (float)0.0f);
            case HeldItemInfoConfig.TextBackgroundVisiblity.NEVER -> 0;
        };
    }

    @Unique
    private void computeMaxWidth() {
        if (this.maxWidth < 0) {
            for (TooltipLine line : this.tooltip) {
                if (line.width <= this.maxWidth) continue;
                this.maxWidth = line.width;
            }
        }
    }

    @Inject(method={"renderOverlayMessage"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTextWithBackground(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;IIII)V")})
    private void onDrawOverlayMessage(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        int tooltipYOffset;
        int difference;
        if (HeldItemInfo.config.preventOverlap() && this.lastTooltipY >= 0 && (difference = VANILLA_TOOLTIP_Y_OFFSET - (tooltipYOffset = context.method_51443() - this.lastTooltipY)) < 0) {
            context.method_51448().translate(0.0f, (float)difference);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void onBeforeTick(CallbackInfo ci) {
        this.stackBeforeTick = this.field_2031;
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void onAfterTick(CallbackInfo ci) {
        if (this.field_2035.field_1724 == null || this.field_2031 == this.stackBeforeTick) {
            return;
        }
        if (this.field_2031.method_7960()) {
            this.tooltip = Collections.emptyList();
        } else {
            List<class_2561> newInfo = this.buildTooltip(this.field_2031);
            if (!TooltipLine.areEquivalent(this.tooltip, newInfo)) {
                this.tooltip = TooltipLine.from(newInfo);
                this.maxWidth = -1;
                this.field_2040 = (int)(20.0f * (HeldItemInfo.config.baseFadeDuration() + HeldItemInfo.config.fadeDurationPerExtraLine() * (float)(this.tooltip.size() - 1)));
            }
        }
    }

    @Unique
    private List<class_2561> buildTooltip(class_1799 stack) {
        if (stack.method_7960()) {
            return Collections.emptyList();
        }
        TooltipBuilder builder = new TooltipBuilder(stack);
        if (HeldItemInfo.config.showName()) {
            class_5250 stackName = class_2561.method_43473().method_10852(stack.method_7964()).method_27692(stack.method_7932().method_58413());
            if (stack.method_57826(class_9334.field_49631)) {
                stackName.method_27692(class_124.field_1056);
            }
            builder.append((class_2561)stackName);
        }
        if (builder.shouldDisplayComponents()) {
            TooltipAppender appender;
            class_1747 blockItem;
            class_2248 class_22482;
            TooltipAppender appender2;
            class_1792 item = stack.method_7909();
            if (item instanceof TooltipAppender && (appender2 = (TooltipAppender)item).heldItemInfo_shouldAppendTooltip()) {
                appender2.heldItemInfo_appendTooltip(builder);
            }
            if (item instanceof class_1747 && (class_22482 = (blockItem = (class_1747)item).method_7711()) instanceof TooltipAppender && (appender = (TooltipAppender)class_22482).heldItemInfo_shouldAppendTooltip()) {
                appender.heldItemInfo_appendTooltip(builder);
            }
            if (HeldItemInfo.config.showEntityBucketContent()) {
                builder.appendComponent(class_9334.field_56151);
            }
            if (HeldItemInfo.config.showGoatHornInstrument()) {
                builder.appendComponent(class_9334.field_49612);
            }
            if (HeldItemInfo.config.showFilledMapId()) {
                builder.appendComponent(class_9334.field_49646);
            }
            if (HeldItemInfo.config.showBeehiveContent()) {
                builder.appendComponent(class_9334.field_49624);
            }
            if (HeldItemInfo.config.showContainerContent()) {
                ContainerContentAppender.appendContainerContent(builder);
            }
            if (HeldItemInfo.config.showBookMeta()) {
                builder.appendComponent(class_9334.field_49606);
            }
            if (HeldItemInfo.config.showCrossbowProjectiles()) {
                builder.appendComponent(class_9334.field_49649, Util::withDefaultColor);
            }
            if (HeldItemInfo.config.showFireworkAttributes()) {
                builder.appendComponent(class_9334.field_49616);
            }
            if (HeldItemInfo.config.showFireworkAttributes()) {
                builder.appendComponent(class_9334.field_49615);
            }
            if (HeldItemInfo.config.showPotionEffects()) {
                Appenders.appendPotionEffects(builder);
            }
            if (HeldItemInfo.config.showMusicDiscDescription()) {
                Appenders.appendMusicDiscDescription(builder);
            }
            if (HeldItemInfo.config.showEnchantments()) {
                Appenders.appendEnchantments(builder);
            }
            if (HeldItemInfo.config.showLore()) {
                Appenders.appendLore(builder);
            }
            if (HeldItemInfo.config.showUnbreakable()) {
                Appenders.appendUnbreakable(builder);
            }
            if (HeldItemInfo.config.showPotionEffects()) {
                builder.appendComponent(class_9334.field_50238);
            }
            if (HeldItemInfo.config.showBlockState()) {
                builder.appendComponent(class_9334.field_49623);
            }
        }
        return builder.build();
    }
}

