/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.fabric.callbacks;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jspecify.annotations.Nullable;

public final class CollectivePlayerEvents {
    public static final Event<Player_Tick> PLAYER_TICK = EventFactory.createArrayBacked(Player_Tick.class, callbacks -> (world, player) -> {
        for (Player_Tick callback : callbacks) {
            callback.onTick(world, player);
        }
    });
    public static final Event<Player_Death> PLAYER_DEATH = EventFactory.createArrayBacked(Player_Death.class, callbacks -> (world, player) -> {
        for (Player_Death callback : callbacks) {
            callback.onDeath(world, player);
        }
    });
    public static final Event<Player_Change_Dimension> PLAYER_CHANGE_DIMENSION = EventFactory.createArrayBacked(Player_Change_Dimension.class, callbacks -> (world, player) -> {
        for (Player_Change_Dimension callback : callbacks) {
            callback.onChangeDimension(world, player);
        }
    });
    public static final Event<Player_Dig_Speed_Calc> ON_PLAYER_DIG_SPEED_CALC = EventFactory.createArrayBacked(Player_Dig_Speed_Calc.class, callbacks -> (world, player, digSpeed, state) -> {
        for (Player_Dig_Speed_Calc callback : callbacks) {
            float newSpeed = callback.onDigSpeedCalc(world, player, digSpeed, state);
            if (newSpeed == digSpeed) continue;
            return newSpeed;
        }
        return -1.0f;
    });
    public static final Event<Player_Picked_Up_Item> ON_ITEM_PICKED_UP = EventFactory.createArrayBacked(Player_Picked_Up_Item.class, callbacks -> (level, player, itemStack) -> {
        for (Player_Picked_Up_Item callback : callbacks) {
            callback.onItemPickedUp(level, player, itemStack);
        }
    });
    public static final Event<Player_Logged_In> PLAYER_LOGGED_IN = EventFactory.createArrayBacked(Player_Logged_In.class, callbacks -> (world, player) -> {
        for (Player_Logged_In callback : callbacks) {
            callback.onPlayerLoggedIn(world, player);
        }
    });
    public static final Event<Player_Logged_Out> PLAYER_LOGGED_OUT = EventFactory.createArrayBacked(Player_Logged_Out.class, callbacks -> (world, player) -> {
        for (Player_Logged_Out callback : callbacks) {
            callback.onPlayerLoggedOut(world, player);
        }
    });

    private CollectivePlayerEvents() {
    }

    @FunctionalInterface
    public static interface Player_Logged_Out {
        public void onPlayerLoggedOut(class_1937 var1, class_1657 var2);
    }

    @FunctionalInterface
    public static interface Player_Logged_In {
        public void onPlayerLoggedIn(class_1937 var1, class_1657 var2);
    }

    @FunctionalInterface
    public static interface Player_Picked_Up_Item {
        public void onItemPickedUp(class_1937 var1, class_1657 var2, @Nullable class_1799 var3);
    }

    @FunctionalInterface
    public static interface Player_Dig_Speed_Calc {
        public float onDigSpeedCalc(class_1937 var1, class_1657 var2, float var3, class_2680 var4);
    }

    @FunctionalInterface
    public static interface Player_Change_Dimension {
        public void onChangeDimension(class_3218 var1, class_3222 var2);
    }

    @FunctionalInterface
    public static interface Player_Death {
        public void onDeath(class_3218 var1, class_3222 var2);
    }

    @FunctionalInterface
    public static interface Player_Tick {
        public void onTick(class_3218 var1, class_3222 var2);
    }
}

