/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.startup;

import mezz.jei.fabric.events.JeiCharTypedEvents;
import mezz.jei.fabric.events.JeiScreenEvents;
import mezz.jei.gui.events.GuiEventHandler;
import mezz.jei.gui.input.ClientInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.startup.JeiEventHandlers;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_1041;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;

public class EventRegistration {
    @Nullable
    private ClientInputHandler clientInputHandler;
    @Nullable
    private GuiEventHandler guiEventHandler;
    private boolean registered;

    public void setEventHandlers(JeiEventHandlers eventHandlers) {
        this.clientInputHandler = eventHandlers.clientInputHandler();
        this.guiEventHandler = eventHandlers.guiEventHandler();
        if (!this.registered) {
            this.registerEvents();
            this.registered = true;
        }
    }

    private void registerEvents() {
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> this.registerScreenEvents(screen));
        JeiCharTypedEvents.BEFORE_CHAR_TYPED.register(this::beforeCharTyped);
        ScreenEvents.AFTER_INIT.register(this::afterInit);
        JeiScreenEvents.DRAW_FOREGROUND.register(this::drawForeground);
        JeiScreenEvents.DRAW_BACKGROUND.register(this::drawBackground);
    }

    private void registerScreenEvents(class_437 screen) {
        if (this.guiEventHandler == null) {
            return;
        }
        ScreenKeyboardEvents.allowKeyPress((class_437)screen).register(this::allowKeyPress);
        ScreenMouseEvents.allowMouseClick((class_437)screen).register(this::allowMouseClick);
        ScreenMouseEvents.allowMouseRelease((class_437)screen).register(this::allowMouseRelease);
        ScreenMouseEvents.allowMouseScroll((class_437)screen).register(this::allowMouseScroll);
    }

    private boolean allowMouseClick(class_437 screen, class_11909 event) {
        if (this.clientInputHandler == null) {
            return true;
        }
        return UserInput.fromVanilla(event, false, InputType.SIMULATE).map(input -> !this.clientInputHandler.onGuiMouseClicked(screen, (UserInput)input)).orElse(true);
    }

    private boolean allowMouseRelease(class_437 screen, class_11909 event) {
        if (this.clientInputHandler == null) {
            return true;
        }
        return UserInput.fromVanilla(event, false, InputType.EXECUTE).map(input -> !this.clientInputHandler.onGuiMouseReleased(screen, (UserInput)input)).orElse(true);
    }

    private boolean allowKeyPress(class_437 screen, class_11908 keyEvent) {
        if (this.clientInputHandler == null) {
            return true;
        }
        UserInput userInput = UserInput.fromVanilla(keyEvent, InputType.IMMEDIATE);
        return !this.clientInputHandler.onKeyboardKeyPressedPre(screen, userInput);
    }

    private boolean allowMouseScroll(class_437 screen, double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.clientInputHandler == null) {
            return false;
        }
        return !this.clientInputHandler.onGuiMouseScroll(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private boolean beforeCharTyped(long windowHandle, class_11905 event) {
        class_437 class_4372;
        class_310 minecraft = class_310.method_1551();
        class_1041 window = minecraft.method_22683();
        if (window.method_4490() == windowHandle && this.clientInputHandler != null && (class_4372 = minecraft.field_1755) instanceof class_437) {
            class_437 screen = class_4372;
            if (minecraft.method_18506() == null) {
                return this.clientInputHandler.onKeyboardCharTypedPre(screen, event);
            }
        }
        return false;
    }

    private void afterInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.onGuiInit(screen);
            this.guiEventHandler.onGuiOpen(screen);
        }
    }

    private void drawForeground(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.drawForContainerScreen(screen, guiGraphics, mouseX, mouseY);
        }
    }

    private void drawBackground(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY, float tickDelta) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.drawForScreen(screen, guiGraphics, mouseX, mouseY);
        }
    }

    public void clear() {
        this.clientInputHandler = null;
        this.guiEventHandler = null;
    }
}

