/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import journeymap.client.Constants;
import journeymap.client.cartography.color.BiomeColor;
import journeymap.client.cartography.color.BlockStateColor;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColorPalette;
import journeymap.client.cartography.color.RGB;
import journeymap.client.model.block.BlockFlag;
import journeymap.client.model.block.BlockMD;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.colorpalette.ColorPaletteScreen;
import journeymap.client.ui.component.MultiSelectableScrollListPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.popupscreenbutton.blockflags.BlockFlagsButton;
import journeymap.client.ui.component.popupscreenbutton.blockflags.BlockFlagsScreen;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerButton;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerScreen;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.Journeymap;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_7923;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public abstract class ColorPaletteItemEditor<T extends ColorItem<?>>
extends JmUI {
    final String labelSelectAll = Constants.getString("jm.colorpalette.select_all");
    final String labelSelectSameColor = Constants.getString("jm.colorpalette.select_same_color");
    final String labelSaveToGlobal = Constants.getString("jm.colorpalette.save_to_global");
    final String labelSaveToWorld = Constants.getString("jm.colorpalette.save_to_world");
    final class_2561 labelClose = class_2561.method_43471((String)"jm.common.close");
    class_8667 buttonHeaderLayout;
    Button buttonSaveToGlobal;
    Button buttonSaveToWorld;
    Button buttonSelectAll;
    Button buttonSelectSameColor;
    final String id;
    MultiSelectableScrollListPane<T> colorsScrollPane;
    final boolean saveToGlobal;
    final boolean saveToWorld;
    int buttonHeaderHeight = 15;

    public ColorPaletteItemEditor(String id, String name, boolean saveToGlobal, boolean saveToWorld, class_437 returnDisplay) {
        super(Constants.getString("jm.colorpalette.edit_title") + " (" + name + ")", true, returnDisplay);
        this.id = id;
        this.saveToGlobal = saveToGlobal;
        this.saveToWorld = saveToWorld;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        class_8667 content = class_8667.method_52741();
        this.contentLayout.method_46441((class_8021)content);
        this.buttonHeaderLayout = class_8667.method_52742();
        this.buttonHeaderLayout.method_52735(2);
        content.method_52738((class_8021)this.buttonHeaderLayout, class_7847::method_46467);
        this.buttonHeaderLayout.method_52736((class_8021)class_7852.method_46513((int)this.buttonHeaderHeight));
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.colorsScrollPane = (MultiSelectableScrollListPane)content.method_52736(new MultiSelectableScrollListPane(this.field_22787, 0, 36 + this.buttonHeaderHeight, this.field_22789, this.field_22790 - 36 - 30 - this.buttonHeaderHeight, 30));
        this.colorsScrollPane.setSlots(this.getItemList());
        this.buttonSelectAll = (Button)this.buttonHeaderLayout.method_52738((class_8021)new Button(this.labelSelectAll, b -> this.colorsScrollPane.selectAll()), class_7847::method_46474);
        this.buttonSelectAll.method_53533(this.buttonHeaderHeight);
        this.buttonSelectAll.setTextOnly(this.getFontRenderer());
        this.buttonSelectAll.drawUnderline(true);
        this.buttonSelectAll.setEnabled(this.colorsScrollPane.getRootSlots().size() > 1);
        this.buttonSelectSameColor = (Button)this.buttonHeaderLayout.method_52738((class_8021)new Button(this.labelSelectSameColor, b -> {
            ColorItem selected = (ColorItem)this.colorsScrollPane.method_25334();
            if (selected != null) {
                for (ColorItem item : this.colorsScrollPane.getRootSlots()) {
                    if (!item.equalColor(selected)) continue;
                    this.colorsScrollPane.setSelectedAndKeepCurrent(item);
                }
            }
        }), class_7847::method_46474);
        this.buttonSelectSameColor.method_53533(this.buttonHeaderHeight);
        this.buttonSelectSameColor.setTextOnly(this.getFontRenderer());
        this.buttonSelectSameColor.drawUnderline(true);
        this.buttonSelectSameColor.setEnabled(this.colorsScrollPane.getRootSlots().size() > 1);
        if (this.saveToGlobal) {
            this.buttonSaveToGlobal = (Button)this.footerLayout.method_52736((class_8021)new Button(this.labelSaveToGlobal, b -> this.save(ColorPalette.Type.Global)));
            this.buttonSaveToGlobal.method_25358(this.field_22793.method_1727(this.labelSaveToGlobal) + 10);
        }
        if (this.saveToWorld) {
            this.buttonSaveToWorld = (Button)this.footerLayout.method_52736((class_8021)new Button(this.labelSaveToWorld, b -> this.save(ColorPalette.Type.World)));
            this.buttonSaveToWorld.method_25358(this.field_22793.method_1727(this.labelSaveToWorld) + 10);
        }
        this.footerLayout.method_52736((class_8021)Button.method_46430((class_2561)this.labelClose, b -> this.refreshAndClose()).method_46432(this.field_22793.method_27525((class_5348)this.labelClose) + 10).method_46431());
        this.validate();
    }

    abstract List<T> getItemList();

    @Override
    protected void method_48640() {
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.colorsScrollPane.updateSize(this.field_22789, this.field_22790 - 36 - 30 - this.buttonHeaderHeight, 0, 36 + this.buttonHeaderHeight);
        this.colorsScrollPane.setListWidth(this.panelWidth());
        this.colorsScrollPane.method_44382(this.colorsScrollPane.method_44387());
        super.method_48640();
    }

    @Override
    public void method_25394(class_332 graphics, int x, int y, float partialTicks) {
        try {
            this.buttonSelectSameColor.setEnabled(this.colorsScrollPane.getRootSlots().size() > 1 && this.colorsScrollPane.getSelectedCount() == 1);
            super.method_25394(graphics, x, y, partialTicks);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            this.outline(graphics, 0, 36, this.field_22789 - 1, this.field_22790 - 66);
            Objects.requireNonNull(this);
            DrawUtil.drawRectangle(graphics, 0.0, 36 + this.buttonHeaderHeight, this.field_22789 - 1, 1.0, 0xC0C0C0, 0.8f);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during ColorPaletteItemEditor render: {}", (Object)LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    protected int panelWidth() {
        return Math.min(this.field_22789, 960);
    }

    protected boolean validate() {
        boolean valid = false;
        for (ColorItem item : this.colorsScrollPane.getRootSlots()) {
            if (!item.isEdited()) continue;
            valid = true;
            break;
        }
        if (this.buttonSaveToGlobal != null) {
            this.buttonSaveToGlobal.setEnabled(valid);
        }
        if (this.buttonSaveToWorld != null) {
            this.buttonSaveToWorld.setEnabled(valid);
        }
        return valid;
    }

    protected void save(ColorPalette.Type type) {
        if (!this.validate()) {
            return;
        }
        ColorPalette palette = type == ColorPalette.Type.Global ? ColorManager.INSTANCE.getGlobalPalette() : ColorManager.INSTANCE.getWorldPalette();
        for (ColorItem item : this.colorsScrollPane.getRootSlots()) {
            item.saveToPalette(palette);
        }
        this.refreshAndClose();
    }

    void popupButtonPressed(ColorItem<?> item) {
        if (!this.colorsScrollPane.isSelectedItem(item)) {
            this.colorsScrollPane.setSelected(item);
        }
    }

    void selectOnly(ColorItem<?> item) {
        this.colorsScrollPane.setSelected(null);
        this.colorsScrollPane.setSelected(item);
    }

    void forEachSelected(Consumer<T> action) {
        for (Slot slot : this.colorsScrollPane.getAllSelected()) {
            ColorItem state = (ColorItem)slot;
            action.accept(state);
        }
        this.validate();
    }

    protected void refreshAndClose() {
        Object object;
        if (returnDisplayStack != null && returnDisplayStack.peek() != null && (object = returnDisplayStack.peek()) instanceof ColorPaletteScreen) {
            ColorPaletteScreen colorPaletteScreen = (ColorPaletteScreen)((Object)object);
            for (ColorItem item : this.colorsScrollPane.getRootSlots()) {
                if (!item.isEdited()) continue;
                colorPaletteScreen.setRemapNeeded();
                break;
            }
        }
        this.closeAndReturn();
    }

    static abstract class ColorItem<T extends ColorPaletteItemEditor<?>>
    extends Slot {
        final class_327 fontRenderer;
        final String id;
        final String name;
        String subtitle = null;
        int color;
        final T editor;
        final Button buttonDefault;
        final Button buttonUndo;
        ColorPickerButton buttonColorPicker;
        final List<class_364> children = new ArrayList<class_364>();
        long lastClick = 0L;

        ColorItem(class_327 fontRenderer, String id, String name, int color, T editor) {
            this.fontRenderer = fontRenderer;
            this.id = id;
            this.name = name;
            this.color = color;
            this.editor = editor;
            this.buttonDefault = new Button(Constants.getString("jm.colorpalette.default"), b -> this.resetItemToDefault());
            this.buttonDefault.fitWidth(fontRenderer);
            this.buttonUndo = new Button(Constants.getString("jm.colorpalette.undo"), b -> this.undoItem());
            this.buttonUndo.fitWidth(fontRenderer);
            this.buttonColorPicker = new ColorPickerButton(24, 24, () -> this.color, this::withAlpha, this::colorPicked);
            this.children.add((class_364)this.buttonColorPicker);
            this.children.add((class_364)this.buttonUndo);
            this.children.add((class_364)this.buttonDefault);
        }

        private void colorPicked(ColorPickerScreen.ColorPickerResponse response) {
            if (response.canceled()) {
                return;
            }
            ((ColorPaletteItemEditor)((Object)this.editor)).forEachSelected(state -> state.setColor(response.color()));
        }

        public void setColor(int color) {
            this.color = color;
        }

        abstract boolean withAlpha();

        abstract void resetItemToDefault();

        abstract void undoItem();

        abstract boolean isEdited();

        abstract void saveToPalette(ColorPalette var1);

        public boolean equalColor(ColorItem<?> other) {
            return this.color == other.color;
        }

        public Collection<SlotMetadata> getMetadata() {
            return null;
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            try {
                if (this.buttonDefault.method_25402(event, doubleClick)) {
                    return true;
                }
                if (this.buttonUndo.method_25402(event, doubleClick)) {
                    return true;
                }
                if (this.buttonColorPicker.method_25402(event, doubleClick)) {
                    ((ColorPaletteItemEditor)((Object)this.editor)).popupButtonPressed(this);
                    ((ColorPaletteItemEditor)this.editor).method_48263(class_8016.method_48192((class_4069)this, (class_8016)class_8016.method_48193((class_364)this.buttonColorPicker)));
                    return false;
                }
                if (event.method_74245() == 0 && doubleClick) {
                    this.buttonColorPicker.method_25306((class_11907)event.comp_4800());
                    ((ColorPaletteItemEditor)((Object)this.editor)).selectOnly(this);
                    return false;
                }
                ((ColorPaletteItemEditor)this.editor).method_48263(class_8016.method_48192((class_4069)this, (class_8016)class_8016.method_48193((class_364)this.buttonColorPicker)));
                return true;
            }
            catch (Exception e) {
                Journeymap.getLogger().error("WARNING: Problem with mouseClicked.");
                throw new RuntimeException("mouseClicked", e);
            }
        }

        public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
            return null;
        }

        public SlotMetadata getLastPressed() {
            return null;
        }

        public SlotMetadata getCurrentTooltip() {
            return null;
        }

        @Override
        public void setEnabled(boolean enabled) {
        }

        @Override
        public int getColumnWidth() {
            return 0;
        }

        public boolean contains(SlotMetadata slotMetadata) {
            return false;
        }

        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            int x = this.method_73380();
            int y = this.method_73382();
            int rowWidth = this.method_73387();
            int itemHeight = this.method_73384();
            graphics.method_25294(x, y, x + rowWidth - 4, y + itemHeight, this.color | 0xFF000000);
            Objects.requireNonNull(this.fontRenderer);
            graphics.method_51433(this.fontRenderer, this.name, x + 5, y + (itemHeight - 9) / 2 - 3, -1, true);
            Objects.requireNonNull(this.fontRenderer);
            graphics.method_51433(this.fontRenderer, this.subtitle, x + 5, y + (itemHeight + 9) / 2 - 2, 0xC0C0C0, true);
            this.buttonDefault.leftOf(x + rowWidth - 57);
            this.buttonDefault.below(y + 3);
            this.buttonDefault.method_25394(graphics, mouseX, mouseY, partialTicks);
            this.buttonUndo.setVisible(this.isEdited());
            this.buttonUndo.leftOf(x + rowWidth - 59 - this.buttonDefault.method_25368());
            this.buttonUndo.below(y + 3);
            this.buttonUndo.method_25394(graphics, mouseX, mouseY, partialTicks);
            if (isMouseOver || this.method_25370()) {
                this.buttonColorPicker.leftOf(x + rowWidth - 5);
                this.buttonColorPicker.below(y + 1);
                this.buttonColorPicker.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public List<? extends class_364> method_25396() {
            return this.children;
        }

        static class Biome
        extends ColorItem<BiomeEditor> {
            private final BiomeColor.Effect effect;
            private final int originalColor;

            Biome(class_327 fontRenderer, String biomeId, BiomeColor.Effect effect, int color, BiomeEditor editor) {
                super(fontRenderer, biomeId, Constants.getString(effect.getKey()), color, editor);
                this.effect = effect;
                this.originalColor = this.color;
            }

            @Override
            public boolean withAlpha() {
                return false;
            }

            @Override
            public void resetItemToDefault() {
                ColorPalette defaultPalette = ColorManager.INSTANCE.getDefaultPalette();
                BiomeColor defaultBC = defaultPalette.getBiomeColor(this.id);
                int color = RGB.hexToInt(defaultBC.getColor(this.effect));
                this.setColor(color);
                ((BiomeEditor)this.editor).validate();
            }

            @Override
            public void undoItem() {
                this.setColor(this.originalColor);
                ((BiomeEditor)this.editor).validate();
            }

            @Override
            public boolean isEdited() {
                return this.color != this.originalColor;
            }

            @Override
            public void saveToPalette(ColorPalette palette) {
                ((BiomeEditor)this.editor).saveToPalette(palette);
            }
        }

        static class Block
        extends ColorItem<BlockEditor> {
            private final String state;
            private final int originalColor;
            private final EnumSet<BlockFlag> originalFlags;
            private EnumSet<BlockFlag> flags;
            private BlockFlagsButton buttonBlockFlags;

            Block(class_327 fontRenderer, String blockId, String state, BlockStateColor blockState, boolean isVanilla, BlockEditor editor) {
                super(fontRenderer, blockId, state, RGB.hexToInt(blockState.color) & 0xFFFFFF | (int)(blockState.alpha.floatValue() * 255.0f) << 24, editor);
                this.state = state;
                this.originalColor = this.color;
                this.originalFlags = blockState.flags == null ? EnumSet.noneOf(BlockFlag.class) : blockState.flags;
                this.flags = this.originalFlags.clone();
                this.subtitle = this.flags.toString();
                if (!isVanilla) {
                    this.buttonBlockFlags = new BlockFlagsButton(24, 24, () -> this.flags, this::flagsChanged);
                    this.children.add(this.buttonBlockFlags);
                }
            }

            private void flagsChanged(BlockFlagsScreen.BlockFlagsResponse response) {
                if (response.canceled()) {
                    return;
                }
                ((BlockEditor)this.editor).forEachSelected(state -> state.setFlags(response.flags()));
            }

            private void setFlags(EnumSet<BlockFlag> flags) {
                this.flags = flags.clone();
                this.subtitle = flags.toString();
            }

            @Override
            public boolean withAlpha() {
                return this.flags.contains((Object)BlockFlag.Transparency);
            }

            @Override
            public void resetItemToDefault() {
                ColorPalette defaultPalette = ColorManager.INSTANCE.getDefaultPalette();
                BlockStateColor defaultBSC = defaultPalette.getBlockStateColor(this.id, this.state);
                EnumSet<BlockFlag> flags = defaultBSC.flags == null ? EnumSet.noneOf(BlockFlag.class) : defaultBSC.flags;
                int color = RGB.hexToInt(defaultBSC.color) & 0xFFFFFF | (int)(defaultBSC.alpha.floatValue() * 255.0f) << 24;
                this.setColor(color);
                this.setFlags(flags);
                ((BlockEditor)this.editor).validate();
            }

            @Override
            public void undoItem() {
                this.setColor(this.originalColor);
                this.setFlags(this.originalFlags);
                ((BlockEditor)this.editor).validate();
            }

            @Override
            public boolean isEdited() {
                return this.color != this.originalColor || !this.flags.equals(this.originalFlags);
            }

            @Override
            public void saveToPalette(ColorPalette palette) {
                float alpha = (float)(this.color >> 24 & 0xFF) / 255.0f;
                palette.setBlockStateColor(this.id, this.state, this.color & 0xFFFFFF, alpha, (EnumSet<BlockFlag>)this.flags.clone());
            }

            @Override
            public boolean method_25402(class_11909 event, boolean doubleClick) {
                if (this.buttonBlockFlags != null && this.buttonBlockFlags.method_25402(event, doubleClick)) {
                    ((BlockEditor)this.editor).popupButtonPressed(this);
                    return false;
                }
                return super.method_25402(event, doubleClick);
            }

            @Override
            public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                super.method_25343(graphics, mouseX, mouseY, isMouseOver, partialTicks);
                if ((isMouseOver || this.method_25370()) && this.buttonBlockFlags != null) {
                    this.buttonBlockFlags.leftOf(this.method_46426() + this.method_73387() - 30);
                    this.buttonBlockFlags.below(this.method_46427() + 1);
                    this.buttonBlockFlags.method_25394(graphics, mouseX, mouseY, partialTicks);
                }
            }
        }
    }

    public static class BiomeEditor
    extends ColorPaletteItemEditor<ColorItem.Biome> {
        private final int originalGrass;
        private final int originalFog;
        private final int originalFoliage;
        private final int originalWater;

        public BiomeEditor(String biomeId, BiomeColor biomeColor, boolean saveToGlobal, boolean saveToWorld, class_437 returnDisplay) {
            super(biomeId, BiomeHelper.getTranslatedBiomeName(class_2960.method_60654((String)biomeId)), saveToGlobal, saveToWorld, returnDisplay);
            this.originalGrass = RGB.hexToInt(biomeColor.grassColor);
            this.originalFog = RGB.hexToInt(biomeColor.fogColor);
            this.originalFoliage = RGB.hexToInt(biomeColor.foliageColor);
            this.originalWater = RGB.hexToInt(biomeColor.waterColor);
        }

        @Override
        List<ColorItem.Biome> getItemList() {
            ArrayList<ColorItem.Biome> items = new ArrayList<ColorItem.Biome>();
            items.add(new ColorItem.Biome(this.field_22793, this.id, BiomeColor.Effect.GRASS, this.originalGrass, this));
            items.add(new ColorItem.Biome(this.field_22793, this.id, BiomeColor.Effect.FOG, this.originalFog, this));
            items.add(new ColorItem.Biome(this.field_22793, this.id, BiomeColor.Effect.FOLIAGE, this.originalFoliage, this));
            items.add(new ColorItem.Biome(this.field_22793, this.id, BiomeColor.Effect.WATER, this.originalWater, this));
            return items;
        }

        public void saveToPalette(ColorPalette palette) {
            if (this.colorsScrollPane.getRootSlots().size() != 4) {
                return;
            }
            int grassColor = ((ColorItem.Biome)((Object)this.colorsScrollPane.getRootSlots().get((int)0))).color;
            int fogColor = ((ColorItem.Biome)((Object)this.colorsScrollPane.getRootSlots().get((int)1))).color;
            int foliageColor = ((ColorItem.Biome)((Object)this.colorsScrollPane.getRootSlots().get((int)2))).color;
            int waterColor = ((ColorItem.Biome)((Object)this.colorsScrollPane.getRootSlots().get((int)3))).color;
            palette.setBiomeColor(this.id, grassColor, fogColor, foliageColor, waterColor);
        }

        @Override
        protected int panelWidth() {
            return Math.min(this.field_22789, 480);
        }
    }

    public static class BlockEditor
    extends ColorPaletteItemEditor<ColorItem.Block> {
        private final Map<String, BlockStateColor> originalColors;

        public BlockEditor(String blockId, Map<String, BlockStateColor> blockStatesToColor, boolean saveToGlobal, boolean saveToWorld, class_437 returnDisplay) {
            super(blockId, BlockMD.getBlockName((class_2248)((class_6880.class_6883)class_7923.field_41175.method_10223(class_2960.method_60654((String)blockId)).get()).comp_349()), saveToGlobal, saveToWorld, returnDisplay);
            this.originalColors = blockStatesToColor;
        }

        @Override
        List<ColorItem.Block> getItemList() {
            boolean isVanilla = this.id.startsWith("minecraft:");
            ArrayList<ColorItem.Block> items = new ArrayList<ColorItem.Block>();
            for (Map.Entry<String, BlockStateColor> state : this.originalColors.entrySet()) {
                items.add(new ColorItem.Block(this.field_22793, this.id, state.getKey(), state.getValue(), isVanilla, this));
            }
            return items;
        }
    }
}

