/*
 * Decompiled with CFR 0.152.
 */
package com.rimo.footprintparticle.config;

import java.util.Arrays;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="footprintparticle")
public class FPPConfig
implements ConfigData {
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    private WorkMode enableMod = WorkMode.ALL;
    @ConfigEntry.BoundedDiscrete(max=30L)
    private int wetDuration = 10;
    @ConfigEntry.BoundedDiscrete(min=1L, max=10L)
    private int secPerPrint = 5;
    private float printLifetime = 5.0f;
    private float watermarkLifetime = 5.0f;
    @ConfigEntry.BoundedDiscrete(max=10L)
    @ConfigEntry.Gui.Tooltip
    private int lifeTimeAcc = 0;
    @ConfigEntry.BoundedDiscrete(max=10L)
    private int footprintAlpha = 7;
    @ConfigEntry.BoundedDiscrete(max=10L)
    private int watermarkAlpha = 4;
    @ConfigEntry.BoundedDiscrete(min=-8L, max=8L)
    @ConfigEntry.Gui.Tooltip
    private int printHeight = 0;
    @ConfigEntry.Gui.Tooltip
    private List<String> applyBlocks = DEF_APPLYBLOCKS;
    @ConfigEntry.Gui.Tooltip
    private float hardnessGate = 0.7f;
    @ConfigEntry.Gui.Tooltip
    private List<String> excludedBlocks = DEF_EXCLUDEDBLOCKS;
    @ConfigEntry.Gui.Tooltip
    private List<String> blockHeight = DEF_BLOCKHEIGHT;
    private boolean canGenWhenInvisible = true;
    @ConfigEntry.Gui.Tooltip
    private List<String> excludedMobs = DEF_MODS;
    @ConfigEntry.Gui.Tooltip
    private List<String> mobInterval = DEF_MOB_INTERVAL;
    @ConfigEntry.Gui.Tooltip
    private List<String> sizePerMob = DEF_SIZE;
    @ConfigEntry.Gui.Tooltip
    private List<String> horseLikeMobs = DEF_FOUR_LEGS;
    @ConfigEntry.Gui.Tooltip
    private List<String> spiderLikeMobs = DEF_EIGHT_LEGS;
    @ConfigEntry.Gui.Tooltip
    private List<String> customPrint = DEF_CUSTOM_PRINT;
    @ConfigEntry.Gui.Tooltip
    private int footprintSize = 5;
    @ConfigEntry.Category(value="misc")
    @ConfigEntry.BoundedDiscrete(max=10L)
    private int railFlameRange = 2;
    @ConfigEntry.Category(value="misc")
    private boolean enableBoatTrail = true;
    @ConfigEntry.Category(value="misc")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    private WorkMode swimPopLevel = WorkMode.ALL;
    @ConfigEntry.Category(value="misc")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    private WorkMode snowDustLevel = WorkMode.ALL;
    @ConfigEntry.Category(value="misc")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    private WorkMode waterSplashLevel = WorkMode.PLAYER_ONLY;
    @ConfigEntry.Gui.Excluded
    private static final List<String> DEF_APPLYBLOCKS = Arrays.asList("#minecraft:wool");
    @ConfigEntry.Gui.Excluded
    private static final List<String> DEF_BLOCKHEIGHT = Arrays.asList("minecraft:snow,0.125", "minecraft:soul_sand,0.125", "minecraft:mud,0.125");
    @ConfigEntry.Gui.Excluded
    private static final List<String> DEF_EXCLUDEDBLOCKS = Arrays.asList("minecraft:beehive", "#minecraft:flower", "#minecraft:crop", "#minecraft:leaves", "#minecraft:sapling", "#minecraft:replaceable_plants");
    @ConfigEntry.Gui.Excluded
    private static final List<String> DEF_MODS = Arrays.asList("#aquatic", "minecraft:parrot", "minecraft:bee", "minecraft:allay", "minecraft:bat", "minecraft:phantom", "minecraft:endermite", "minecraft:blaze", "minecraft:ghast", "minecraft:wither", "minecraft:ender_dragon");
    @ConfigEntry.Gui.Excluded
    private static final List<String> DEF_SIZE = Arrays.asList("minecraft:chicken,0.6", "minecraft:pig,0.8", "minecraft:cat,0.5", "minecraft:ocelot,0.5", "minecraft:wolf,0.6", "minecraft:sniffer,1.6", "minecraft:enderman,0.6", "minecraft:slime,2", "minecraft:magma_cube,2", "minecraft:creeper,0.8", "minecraft:iron_golem,1.2", "minecraft:ravager,2", "minecraft:armadillo,0.7");
    @ConfigEntry.Gui.Excluded
    private static final List<String> DEF_FOUR_LEGS = Arrays.asList("minecraft:horse", "minecraft:donkey", "minecraft:mule", "minecraft:zombie_horse", "minecraft:skeleton_horse", "minecraft:camel", "minecraft:sniffer,0.8", "minecraft:ravager,0.5", "minecraft:creeper,0.3");
    @ConfigEntry.Gui.Excluded
    private static final List<String> DEF_EIGHT_LEGS = Arrays.asList("minecraft:spider", "minecraft:cave_spider", "minecraft:camel,0.3", "minecraft:sniffer,0.3", "minecraft:iron_golem,0.3", "minecraft:ravager,0.3");
    @ConfigEntry.Gui.Excluded
    private static final List<String> DEF_MOB_INTERVAL = Arrays.asList("minecraft:spider,0.5", "minecraft:cave_spider,0.5", "minecraft:camel,2", "minecraft:sniffer,3", "minecraft:iron_golem,2", "minecraft:creeper,0.8");
    @ConfigEntry.Gui.Excluded
    private static final List<String> DEF_CUSTOM_PRINT = Arrays.asList("mod_id:mob_id,fileName_NoExtend");

    public int isEnable() {
        return this.enableMod.ordinal();
    }

    public float getSecPerPrint() {
        return (float)this.secPerPrint / 10.0f;
    }

    public float getPrintLifetime() {
        return this.printLifetime;
    }

    public float getWatermarkLifetime() {
        return this.watermarkLifetime;
    }

    public int getLifeTimeAcc() {
        return this.lifeTimeAcc;
    }

    public float getPrintHeight() {
        return (float)this.printHeight / 0.0625f;
    }

    public List<String> getApplyBlocks() {
        return this.applyBlocks;
    }

    public List<String> getBlockHeight() {
        return this.blockHeight;
    }

    public List<String> getExcludedBlocks() {
        return this.excludedBlocks;
    }

    public boolean getCanGenWhenInvisible() {
        return this.canGenWhenInvisible;
    }

    public List<String> getExcludedMobs() {
        return this.excludedMobs;
    }

    public List<String> getSizePerMob() {
        return this.sizePerMob;
    }

    public List<String> getHorseLikeMobs() {
        return this.horseLikeMobs;
    }

    public List<String> getSpiderLikeMobs() {
        return this.spiderLikeMobs;
    }

    public int getWetDuration() {
        return this.wetDuration;
    }

    public float getWatermarkAlpha() {
        return (float)this.watermarkAlpha / 10.0f;
    }

    public float getFootprintAlpha() {
        return (float)this.footprintAlpha / 10.0f;
    }

    public List<String> getMobInterval() {
        return this.mobInterval;
    }

    public int getFootprintSize() {
        return this.footprintSize;
    }

    public List<String> getCustomPrint() {
        return this.customPrint;
    }

    public float getHardnessGate() {
        return this.hardnessGate;
    }

    public float getRailFlameRange() {
        return (float)this.railFlameRange / 10.0f;
    }

    public boolean isEnableBoatTrail() {
        return this.enableBoatTrail;
    }

    public int getSwimPopLevel() {
        return this.swimPopLevel.ordinal();
    }

    public int getSnowDustLevel() {
        return this.snowDustLevel.ordinal();
    }

    public int getWaterSplashLevel() {
        return this.waterSplashLevel.ordinal();
    }

    public static enum WorkMode {
        DISABLED("text.footprintparticle.disabled"),
        PLAYER_ONLY("text.footprintparticle.player_only"),
        ALL("text.footprintparticle.all");

        private final String key;

        private WorkMode(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }
}

