/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalDoubleRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableDouble;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.entity.living.CalculateLivingVisibilityCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDeathCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingFallCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingJumpCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingKnockBackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.MobEffectEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.PickProjectileCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.ShieldBlockCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLivingEvents;
import fuzs.puzzleslib.fabric.impl.event.CapturedDropsEntity;
import fuzs.puzzleslib.fabric.impl.event.FabricEventImplHelper;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.event.EventImplHelper;
import fuzs.puzzleslib.impl.event.data.DefaultedDouble;
import fuzs.puzzleslib.impl.event.data.DefaultedFloat;
import fuzs.puzzleslib.impl.event.data.DefaultedInt;
import fuzs.puzzleslib.impl.event.data.DefaultedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
abstract class LivingEntityFabricMixin
extends class_1297
implements CapturedDropsEntity {
    @Shadow
    protected class_1799 field_6277;
    @Shadow
    protected int field_6222;
    @Shadow
    protected int field_6238;
    @Shadow
    @Final
    private Map<class_6880<class_1291>, class_1293> field_6280;

    public LivingEntityFabricMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"method_6078(Lnet/minecraft/class_1282;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void die(class_1282 damageSource, CallbackInfo callback) {
        EventResult eventResult = ((LivingDeathCallback)FabricLivingEvents.LIVING_DEATH.invoker()).onLivingDeath((class_1309)class_1309.class.cast(this), damageSource);
        if (eventResult.isInterrupt()) {
            callback.cancel();
        }
    }

    @Inject(method={"method_6019(Lnet/minecraft/class_1268;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/class_1309;field_6222:I", shift=At.Shift.AFTER, opcode=181)}, cancellable=true)
    public void startUsingItem(class_1268 interactionHand, CallbackInfo callback) {
        DefaultedInt useItemRemaining = DefaultedInt.fromValue(this.field_6222);
        EventResult eventResult = ((UseItemEvents.Start)FabricLivingEvents.USE_ITEM_START.invoker()).onUseItemStart((class_1309)class_1309.class.cast(this), this.field_6277, interactionHand, useItemRemaining);
        if (eventResult.isInterrupt()) {
            this.field_6277 = class_1799.field_8037;
            this.field_6222 = 0;
            callback.cancel();
        } else {
            this.field_6222 = useItemRemaining.getAsOptionalInt().orElse(this.field_6222);
        }
    }

    @Inject(method={"method_37119(Lnet/minecraft/class_1799;)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void updateUsingItem(class_1799 usingItem, CallbackInfo callback) {
        if (!usingItem.method_7960()) {
            DefaultedInt remainingUseDuration = DefaultedInt.fromValue(this.method_6014());
            EventResult eventResult = ((UseItemEvents.Tick)FabricLivingEvents.USE_ITEM_TICK.invoker()).onUseItemTick((class_1309)class_1309.class.cast(this), usingItem, this.method_6058(), remainingUseDuration);
            remainingUseDuration.getAsOptionalInt().ifPresent(useItemRemaining -> {
                this.field_6222 = useItemRemaining == 0 ? 1 : useItemRemaining;
            });
            if (eventResult.isInterrupt()) {
                if (--this.field_6222 == 0 && !this.method_73183().method_8608() && !usingItem.method_7967()) {
                    this.method_6040();
                }
                callback.cancel();
            }
        }
    }

    @Shadow
    public abstract int method_6014();

    @Shadow
    protected abstract void method_6040();

    @Shadow
    private void method_6076() {
        throw new RuntimeException();
    }

    @Inject(method={"method_6040()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1799;method_7910(Lnet/minecraft/class_1937;Lnet/minecraft/class_1309;)Lnet/minecraft/class_1799;")})
    protected void completeUsingItem(CallbackInfo callback, @Share(value="originalUseItem") LocalRef<class_1799> originalUseItem) {
        originalUseItem.set((Object)this.field_6277.method_7972());
    }

    @ModifyVariable(method={"method_6040()V"}, at=@At(value="STORE"), ordinal=0)
    protected class_1799 completeUsingItem(class_1799 useItem, @Share(value="originalUseItem") LocalRef<class_1799> originalUseItem) {
        Objects.requireNonNull((class_1799)originalUseItem.get(), "original use item is null");
        DefaultedValue<class_1799> itemStack = DefaultedValue.fromValue(useItem);
        ((UseItemEvents.Finish)FabricLivingEvents.USE_ITEM_FINISH.invoker()).onUseItemFinish((class_1309)class_1309.class.cast(this), itemStack, (class_1799)originalUseItem.get(), this.method_6058());
        return itemStack.getAsOptional().orElse(useItem);
    }

    @Shadow
    public abstract void method_6021();

    @Inject(method={"method_6075()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void releaseUsingItem(CallbackInfo callback) {
        if (!this.field_6277.method_7960()) {
            if (((UseItemEvents.Stop)FabricLivingEvents.USE_ITEM_STOP.invoker()).onUseItemStop((class_1309)class_1309.class.cast(this), this.field_6277, this.method_6058(), this.field_6222).isPass()) {
                return;
            }
            if (this.field_6277.method_7967()) {
                this.method_6076();
            }
            this.method_6021();
            callback.cancel();
        }
    }

    @Inject(method={"method_16080(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;)V"}, at={@At(value="HEAD")})
    protected void dropAllDeathLoot$1(class_3218 level, class_1282 damageSource, CallbackInfo callback) {
        this.puzzleslib$acceptCapturedDrops(new ArrayList());
    }

    @Inject(method={"method_16080(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;)V"}, at={@At(value="TAIL")})
    protected void dropAllDeathLoot$2(class_3218 level, class_1282 damageSource, CallbackInfo callback) {
        if (!FabricEventImplHelper.tryOnLivingDrops((class_1309)class_1309.class.cast(this), damageSource, this.field_6238)) {
            PuzzlesLib.LOGGER.warn("Unable to invoke LivingDropsCallback for entity {}: Drops is null", (Object)this.method_5477().getString());
        }
    }

    @Inject(method={"method_6078(Lnet/minecraft/class_1282;)V"}, at={@At(value="TAIL")})
    public void die$1(class_1282 damageSource, CallbackInfo callback) {
        FabricEventImplHelper.tryOnLivingDrops((class_1309)class_1309.class.cast(this), damageSource, this.field_6238);
    }

    @Inject(method={"method_7329(Lnet/minecraft/class_1799;ZZ)Lnet/minecraft/class_1542;"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1937;method_8649(Lnet/minecraft/class_1297;)Z")}, cancellable=true)
    public void drop(CallbackInfoReturnable<class_1542> callback, @Local class_1542 itemEntity) {
        Collection capturedDrops = this.puzzleslib$getCapturedDrops();
        if (capturedDrops != null) {
            capturedDrops.add(itemEntity);
            callback.setReturnValue((Object)itemEntity);
        }
    }

    @Inject(method={"method_23883(Lnet/minecraft/class_3218;Lnet/minecraft/class_1297;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1303;method_31493(Lnet/minecraft/class_3218;Lnet/minecraft/class_243;I)V")}, cancellable=true)
    protected void dropExperience(class_3218 serverLevel, @Nullable class_1297 killer, CallbackInfo callback) {
        DefaultedInt experienceReward = DefaultedInt.fromValue(this.method_6110(serverLevel));
        EventResult eventResult = ((LivingExperienceDropCallback)FabricLivingEvents.EXPERIENCE_DROP.invoker()).onLivingExperienceDrop((class_1309)class_1309.class.cast(this), this.method_66280(), experienceReward);
        if (eventResult.isInterrupt()) {
            callback.cancel();
        } else {
            experienceReward.getAsOptionalInt().ifPresent(value -> {
                class_1303.method_31493((class_3218)((class_3218)this.method_73183()), (class_243)this.method_73189(), (int)value);
                callback.cancel();
            });
        }
    }

    @Shadow
    protected abstract int method_6110(class_3218 var1);

    @Shadow
    public abstract @Nullable class_1657 method_66280();

    @ModifyVariable(method={"method_6074(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    protected float actuallyHurt(float damageAmount, class_3218 serverLevel, class_1282 damageSource, @Cancellable CallbackInfo callback) {
        if (!this.method_5679(serverLevel, damageSource)) {
            MutableBoolean cancelInjection = new MutableBoolean();
            damageAmount = FabricEventImplHelper.onLivingHurt((class_1309)class_1309.class.cast(this), serverLevel, damageSource, damageAmount, cancelInjection);
            if (cancelInjection.booleanValue()) {
                callback.cancel();
            }
        }
        return damageAmount;
    }

    @Shadow
    public abstract boolean method_5679(class_3218 var1, class_1282 var2);

    @ModifyExpressionValue(method={"method_67346(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)F"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_10707;method_67202(Lnet/minecraft/class_1282;FD)F")})
    public float applyItemBlocking(float blockedDamage, class_3218 serverLevel, class_1282 damageSource, float damageAmount, @Cancellable CallbackInfoReturnable<Float> callback) {
        DefaultedFloat blockedDamageValue = DefaultedFloat.fromValue(blockedDamage);
        EventResult eventResult = ((ShieldBlockCallback)FabricLivingEvents.SHIELD_BLOCK.invoker()).onShieldBlock((class_1309)class_1309.class.cast(this), damageSource, blockedDamageValue);
        if (eventResult.isInterrupt()) {
            callback.setReturnValue((Object)Float.valueOf(0.0f));
            return 0.0f;
        }
        return blockedDamageValue.getAsFloat();
    }

    @Inject(method={"method_5747(DFLnet/minecraft/class_1282;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void causeFallDamage(CallbackInfoReturnable<Boolean> callback, @Local(ordinal=0, argsOnly=true) LocalDoubleRef fallDistanceRef, @Local(ordinal=0, argsOnly=true) LocalFloatRef damageMultiplierRef) {
        MutableDouble fallDistance = MutableDouble.fromEvent(arg_0 -> ((LocalDoubleRef)fallDistanceRef).set(arg_0), () -> ((LocalDoubleRef)fallDistanceRef).get());
        MutableFloat damageMultiplier = MutableFloat.fromEvent(arg_0 -> ((LocalFloatRef)damageMultiplierRef).set(arg_0), () -> ((LocalFloatRef)damageMultiplierRef).get());
        EventResult eventResult = ((LivingFallCallback)FabricLivingEvents.LIVING_FALL.invoker()).onLivingFall((class_1309)class_1309.class.cast(this), fallDistance, damageMultiplier);
        if (eventResult.isInterrupt()) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(method={"method_6005(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void knockback(CallbackInfo callback, @Local(ordinal=0, argsOnly=true) LocalDoubleRef strengthRef, @Local(ordinal=1, argsOnly=true) LocalDoubleRef ratioXRef, @Local(ordinal=2, argsOnly=true) LocalDoubleRef ratioZRef) {
        MutableDouble knockbackStrength = MutableDouble.fromEvent(arg_0 -> ((LocalDoubleRef)strengthRef).set(arg_0), () -> ((LocalDoubleRef)strengthRef).get());
        MutableDouble ratioX = MutableDouble.fromEvent(arg_0 -> ((LocalDoubleRef)ratioXRef).set(arg_0), () -> ((LocalDoubleRef)ratioXRef).get());
        MutableDouble ratioZ = MutableDouble.fromEvent(arg_0 -> ((LocalDoubleRef)ratioZRef).set(arg_0), () -> ((LocalDoubleRef)ratioZRef).get());
        EventResult eventResult = ((LivingKnockBackCallback)FabricLivingEvents.LIVING_KNOCK_BACK.invoker()).onLivingKnockBack((class_1309)class_1309.class.cast(this), knockbackStrength, ratioX, ratioZ);
        if (eventResult.isInterrupt()) {
            callback.cancel();
        }
    }

    @ModifyVariable(method={"method_37222(Lnet/minecraft/class_1293;Lnet/minecraft/class_1297;)Z"}, at=@At(value="STORE"), ordinal=1)
    public class_1293 addEffect(@Nullable class_1293 oldEffectInstance, class_1293 mobEffect, @Nullable class_1297 entity) {
        ((MobEffectEvents.Apply)FabricLivingEvents.MOB_EFFECT_APPLY.invoker()).onMobEffectApply((class_1309)class_1309.class.cast(this), mobEffect, oldEffectInstance, entity);
        return oldEffectInstance;
    }

    @Inject(method={"method_6049(Lnet/minecraft/class_1293;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void canBeAffected(class_1293 mobEffect, CallbackInfoReturnable<Boolean> callback) {
        EventResult eventResult = ((MobEffectEvents.Affects)FabricLivingEvents.MOB_EFFECT_AFFECTS.invoker()).onMobEffectAffects((class_1309)class_1309.class.cast(this), mobEffect);
        if (eventResult.isInterrupt()) {
            callback.setReturnValue((Object)eventResult.getAsBoolean());
        }
    }

    @Inject(method={"method_6016(Lnet/minecraft/class_6880;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void removeEffect(class_6880<class_1291> effect, CallbackInfoReturnable<Boolean> callback) {
        EventResult eventResult = ((MobEffectEvents.Remove)FabricLivingEvents.MOB_EFFECT_REMOVE.invoker()).onMobEffectRemove((class_1309)class_1309.class.cast(this), this.method_6112(effect));
        if (eventResult.isInterrupt()) {
            callback.setReturnValue((Object)false);
        }
    }

    @Shadow
    public abstract @Nullable class_1293 method_6112(class_6880<class_1291> var1);

    @Inject(method={"method_6012()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void removeAllEffects(CallbackInfoReturnable<Boolean> callback) {
        if (this.method_73183().method_8608() || this.field_6280.isEmpty()) {
            return;
        }
        HashMap<class_6880<class_1291>, class_1293> removedActiveEffects = new HashMap<class_6880<class_1291>, class_1293>();
        for (Map.Entry<class_6880<class_1291>, class_1293> entry : this.field_6280.entrySet()) {
            EventResult eventResult = ((MobEffectEvents.Remove)FabricLivingEvents.MOB_EFFECT_REMOVE.invoker()).onMobEffectRemove((class_1309)class_1309.class.cast(this), entry.getValue());
            if (!eventResult.isPass()) continue;
            removedActiveEffects.put(entry.getKey(), entry.getValue());
        }
        if (removedActiveEffects.size() != this.field_6280.size()) {
            removedActiveEffects.keySet().forEach(this.field_6280::remove);
            this.method_6129(removedActiveEffects.values());
            callback.setReturnValue((Object)true);
        }
    }

    @Shadow
    protected abstract void method_6129(Collection<class_1293> var1);

    @Shadow
    public abstract class_1268 method_6058();

    @ModifyVariable(method={"method_6050()V"}, at=@At(value="INVOKE", target="Ljava/util/Iterator;remove()V"), ordinal=0)
    protected class_1293 tickEffects(class_1293 mobEffectInstance) {
        ((MobEffectEvents.Expire)FabricLivingEvents.MOB_EFFECT_EXPIRE.invoker()).onMobEffectExpire((class_1309)class_1309.class.cast(this), mobEffectInstance);
        return mobEffectInstance;
    }

    @Inject(method={"method_6043()V"}, at={@At(value="TAIL")})
    protected void jumpFromGround(CallbackInfo callback) {
        EventImplHelper.onLivingJump((LivingJumpCallback)FabricLivingEvents.LIVING_JUMP.invoker(), (class_1309)class_1309.class.cast(this));
    }

    @ModifyVariable(method={"method_18390(Lnet/minecraft/class_1297;)D"}, at=@At(value="TAIL"), ordinal=0)
    public double getVisibilityPercent(double value, @Nullable class_1297 lookingEntity) {
        DefaultedDouble visibilityPercentage = DefaultedDouble.fromValue(value);
        ((CalculateLivingVisibilityCallback)FabricLivingEvents.CALCULATE_LIVING_VISIBILITY.invoker()).onCalculateLivingVisibility((class_1309)class_1309.class.cast(this), lookingEntity, visibilityPercentage);
        return visibilityPercentage.getAsOptionalDouble().stream().map(visibilityPercentageValue -> Math.max(visibilityPercentageValue, 0.0)).findAny().orElse(value);
    }

    @ModifyReturnValue(method={"method_18808(Lnet/minecraft/class_1799;)Lnet/minecraft/class_1799;"}, at={@At(value="RETURN")})
    public class_1799 getProjectile(class_1799 projectileItemStack, class_1799 weaponItemStack) {
        if (weaponItemStack.method_7909() instanceof class_1811) {
            DefaultedValue<class_1799> projectileItemStackValue = DefaultedValue.fromValue(projectileItemStack);
            ((PickProjectileCallback)FabricLivingEvents.PICK_PROJECTILE.invoker()).onPickProjectile((class_1309)class_1309.class.cast(this), weaponItemStack, projectileItemStackValue);
            return projectileItemStackValue.getAsOptional().orElse(projectileItemStack);
        }
        return projectileItemStack;
    }
}

