/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.chunkFileHandling;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.chunkFileHandling.CompoundTagUtil;
import net.minecraft.class_11897;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2843;
import net.minecraft.class_2902;
import net.minecraft.class_5281;
import net.minecraft.class_5455;
import net.minecraft.class_6563;
import net.minecraft.class_6755;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import net.minecraft.class_7924;

public class ChunkCompoundTagParser {
    public static final DhLogger LOGGER = new DhLoggerBuilder().name("LOD Chunk Reader").fileLevelConfig(Config.Common.Logging.logWorldGenChunkLoadEventToFile).build();
    private static final AtomicBoolean ZERO_CHUNK_POS_ERROR_LOGGED_REF = new AtomicBoolean(false);
    private static final ConcurrentHashMap<String, Object> LOGGED_ERROR_MESSAGE_MAP = new ConcurrentHashMap();
    private static boolean lightingSectionErrorLogged = false;

    public static ChunkWrapper createFromTag(class_5281 mcWorldGenLevel, IDhServerLevel dhServerLevel, class_1923 chunkPos, class_2487 chunkData) {
        int chunkZ;
        class_2487 tagLevel = chunkData;
        int chunkX = CompoundTagUtil.getInt(tagLevel, "xPos");
        class_1923 actualChunkPos = new class_1923(chunkX, chunkZ = CompoundTagUtil.getInt(tagLevel, "zPos"));
        if (!Objects.equals(chunkPos, actualChunkPos)) {
            if (chunkX == 0 && chunkZ == 0) {
                if (!ZERO_CHUNK_POS_ERROR_LOGGED_REF.getAndSet(true)) {
                    LOGGER.warn("Chunk file at [" + chunkPos.toString() + "] doesn't have a chunk pos. \nThis might happen if the world was created using an external program. \nDH will attempt to parse the chunk anyway and won't log this message again.\nIf issues arise please try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen. ", new Object[0]);
                }
            } else {
                LOGGER.error("Chunk file at [" + chunkPos.toString() + "] is in the wrong location. \nPlease try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen. \n(Expected pos: [" + chunkPos.toString() + "], actual [" + actualChunkPos.toString() + "]) ", new Object[0]);
                return null;
            }
        }
        class_6755 blockTicks = new class_6755();
        class_6755 fluidTicks = new class_6755();
        int sectionYCount = mcWorldGenLevel.method_32890();
        class_2826[] chunkSections = new class_2826[sectionYCount];
        boolean hasBlocks = ChunkCompoundTagParser.readAndPopulateSections((class_1936)mcWorldGenLevel, chunkPos, tagLevel, chunkSections);
        if (!hasBlocks) {
            return null;
        }
        long inhabitedTime = CompoundTagUtil.getLong(tagLevel, "InhabitedTime");
        boolean isLightOn = CompoundTagUtil.getBoolean(tagLevel, "isLightOn");
        class_2818 chunk = new class_2818((class_1937)mcWorldGenLevel, chunkPos, class_2843.field_12950, blockTicks, fluidTicks, inhabitedTime, chunkSections, null, null);
        chunk.method_12020(isLightOn);
        boolean hasHeightmapData = ChunkCompoundTagParser.readHeightmaps(chunk, chunkData);
        ChunkWrapper chunkWrapper = new ChunkWrapper((class_2791)chunk, dhServerLevel.getServerLevelWrapper(), !hasHeightmapData);
        boolean chunkHasBlocks = false;
        int serverMinHeight = dhServerLevel.getServerLevelWrapper().getMinHeight();
        for (int x = 0; x < 16 && !chunkHasBlocks; ++x) {
            for (int z = 0; z < 16 && !chunkHasBlocks; ++z) {
                int heightMap = Math.max(chunkWrapper.getLightBlockingHeightMapValue(x, z), chunkWrapper.getSolidHeightMapValue(x, z));
                if (heightMap == serverMinHeight) continue;
                chunkHasBlocks = true;
            }
        }
        if (chunkHasBlocks) {
            return chunkWrapper;
        }
        return null;
    }

    private static boolean readAndPopulateSections(class_1936 level, class_1923 chunkPos, class_2487 chunkData, class_2826[] chunkSections) {
        int sectionYCount = level.method_32890();
        class_2499 tagSections = CompoundTagUtil.getListTag(chunkData, "Sections", 10);
        if (tagSections == null || tagSections.isEmpty()) {
            tagSections = CompoundTagUtil.getListTag(chunkData, "sections", 10);
        }
        boolean blocksFound = false;
        if (tagSections != null) {
            for (int i = 0; i < tagSections.size(); ++i) {
                class_2841 blockStateContainer;
                byte sectionYPos;
                int sectionId;
                class_2487 tagSection = CompoundTagUtil.getCompoundTag(tagSections, i);
                if (tagSection == null || (sectionId = level.method_31603((int)(sectionYPos = CompoundTagUtil.getByte(tagSection, "Y")))) < 0 || sectionId >= chunkSections.length) continue;
                boolean containsBlockStates = CompoundTagUtil.contains(tagSection, "block_states", 10);
                if (containsBlockStates) {
                    Codec<class_2841<class_2680>> blockStateCodec = ChunkCompoundTagParser.getBlockStateCodec(level);
                    blockStateContainer = (class_2841)blockStateCodec.parse((DynamicOps)class_2509.field_11560, (Object)CompoundTagUtil.getCompoundTag(tagSection, "block_states")).promotePartial(string -> ChunkCompoundTagParser.logBlockDeserializationWarning(chunkPos, sectionYPos, string)).getOrThrow(message -> ChunkCompoundTagParser.logErrorAndReturnException(message));
                    blocksFound = true;
                } else {
                    blockStateContainer = class_11897.method_74159((class_5455)level.method_30349()).method_74158();
                }
                class_2378<class_1959> biomeRegistry = ChunkCompoundTagParser.getBiomeRegistry(level);
                Codec<class_2841<class_6880<class_1959>>> biomeCodec = ChunkCompoundTagParser.getBiomeCodec(level, biomeRegistry);
                class_2487 biomeTag = CompoundTagUtil.getCompoundTag(tagSection, "biomeRegistry");
                if (biomeTag == null) {
                    biomeTag = CompoundTagUtil.getCompoundTag(tagSection, "biomes");
                }
                class_2841 biomeContainer = biomeTag != null && !biomeTag.method_33133() ? (class_2841)biomeCodec.parse((DynamicOps)class_2509.field_11560, (Object)biomeTag).promotePartial(string -> ChunkCompoundTagParser.logBiomeDeserializationWarning(chunkPos, sectionYCount, string)).getOrThrow(message -> ChunkCompoundTagParser.logErrorAndReturnException(message)) : class_11897.method_74159((class_5455)level.method_30349()).method_74160();
                chunkSections[sectionId] = new class_2826(blockStateContainer, (class_7522)biomeContainer);
            }
        }
        return blocksFound;
    }

    private static Codec<class_2841<class_2680>> getBlockStateCodec(class_1936 level) {
        return class_11897.method_74159((class_5455)level.method_30349()).comp_4787();
    }

    private static class_2378<class_1959> getBiomeRegistry(class_1936 level) {
        return level.method_30349().method_30530(class_7924.field_41236);
    }

    private static Codec<class_2841<class_6880<class_1959>>> getBiomeCodec(class_1936 level, class_2378<class_1959> biomeRegistry) {
        return class_2841.method_44343((Codec)biomeRegistry.method_40294(), (class_6563)class_11897.method_74159((class_5455)level.method_30349()).comp_4788(), (Object)biomeRegistry.method_46747(class_1972.field_9451));
    }

    private static boolean readHeightmaps(class_2818 chunk, class_2487 chunkData) {
        class_2487 tagHeightmaps = CompoundTagUtil.getCompoundTag(chunkData, "Heightmaps");
        if (tagHeightmaps == null) {
            return false;
        }
        for (class_2902.class_2903 type : class_2806.field_12803.method_12160()) {
            Optional optionalHeightmap;
            String heightmapKey = type.method_12605();
            if (!tagHeightmaps.method_10545(heightmapKey) || !(optionalHeightmap = tagHeightmaps.method_10565(heightmapKey)).isPresent()) continue;
            chunk.method_12037(type, (long[])optionalHeightmap.get());
        }
        class_2902.method_16684((class_2791)chunk, (Set)class_2806.field_12803.method_12160());
        return true;
    }

    public static CombinedChunkLightStorage readLight(class_2791 chunk, class_2487 chunkData) {
        CombinedChunkLightStorage combinedStorage = new CombinedChunkLightStorage(ChunkWrapper.getInclusiveMinBuildHeight(chunk), ChunkWrapper.getExclusiveMaxBuildHeight(chunk));
        ChunkLightStorage blockLightStorage = combinedStorage.blockLightStorage;
        ChunkLightStorage skyLightStorage = combinedStorage.skyLightStorage;
        boolean foundSkyLight = false;
        class_2520 chunkSectionTags = chunkData.method_10580("sections");
        if (chunkSectionTags == null) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("No sections found for chunk at pos [" + String.valueOf(chunk.method_12004()) + "] chunk data may be out of date.", new Object[0]);
            }
            return null;
        }
        if (!(chunkSectionTags instanceof class_2499)) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("Chunk section tag list have unexpected type [" + chunkSectionTags.getClass().getName() + "], expected [" + class_2499.class.getName() + "].", new Object[0]);
            }
            return null;
        }
        class_2499 chunkSectionListTag = (class_2499)chunkSectionTags;
        for (int sectionIndex = 0; sectionIndex < chunkSectionListTag.size(); ++sectionIndex) {
            class_2520 chunkSectionTag = chunkSectionListTag.method_10534(sectionIndex);
            if (!(chunkSectionTag instanceof class_2487)) {
                if (!lightingSectionErrorLogged) {
                    lightingSectionErrorLogged = true;
                    LOGGER.error("Chunk section tag has an unexpected type [" + chunkSectionTag.getClass().getName() + "], expected [" + class_2487.class.getName() + "].", new Object[0]);
                }
                return null;
            }
            class_2487 chunkSectionCompoundTag = (class_2487)chunkSectionTag;
            byte[] blockLightNibbleArray = CompoundTagUtil.getByteArray(chunkSectionCompoundTag, "BlockLight");
            byte[] skyLightNibbleArray = CompoundTagUtil.getByteArray(chunkSectionCompoundTag, "SkyLight");
            if (blockLightNibbleArray == null || skyLightNibbleArray == null) continue;
            if (skyLightNibbleArray.length != 0) {
                foundSkyLight = true;
            }
            for (int relX = 0; relX < 16; ++relX) {
                for (int relZ = 0; relZ < 16; ++relZ) {
                    for (int relY = 0; relY < 16; ++relY) {
                        int skyLight;
                        int blockPosIndex = relY * 16 * 16 + relZ * 16 + relX;
                        byte blockLight = blockLightNibbleArray.length == 0 ? (byte)0 : ChunkCompoundTagParser.getNibbleAtIndex(blockLightNibbleArray, blockPosIndex);
                        int n = skyLight = skyLightNibbleArray.length == 0 ? 0 : ChunkCompoundTagParser.getNibbleAtIndex(skyLightNibbleArray, blockPosIndex);
                        if (skyLightNibbleArray.length == 0 && foundSkyLight) {
                            skyLight = 15;
                        }
                        int y = relY + sectionIndex * 16 + ChunkWrapper.getInclusiveMinBuildHeight(chunk);
                        blockLightStorage.set(relX, y, relZ, blockLight);
                        skyLightStorage.set(relX, y, relZ, skyLight);
                    }
                }
            }
        }
        return combinedStorage;
    }

    private static byte getNibbleAtIndex(byte[] arr, int index) {
        if (index % 2 == 0) {
            return (byte)(arr[index / 2] & 0xF);
        }
        return (byte)(arr[index / 2] >> 4 & 0xF);
    }

    private static void logBlockDeserializationWarning(class_1923 chunkPos, int sectionYIndex, String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Unable to deserialize blocks for chunk section [" + chunkPos.field_9181 + ", " + sectionYIndex + ", " + chunkPos.field_9180 + "], error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
    }

    private static void logBiomeDeserializationWarning(class_1923 chunkPos, int sectionYIndex, String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Unable to deserialize biomes for chunk section [" + chunkPos.field_9181 + ", " + sectionYIndex + ", " + chunkPos.field_9180 + "], error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
    }

    private static void logParsingWarningOnce(String message) {
        ChunkCompoundTagParser.logParsingWarningOnce(message, null);
    }

    private static void logParsingWarningOnce(String message, Exception e) {
        if (message == null) {
            return;
        }
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Parsing error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", e);
            return newMessage;
        });
    }

    private static RuntimeException logErrorAndReturnException(String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Parsing error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
        return null;
    }

    public static class CombinedChunkLightStorage {
        public ChunkLightStorage blockLightStorage;
        public ChunkLightStorage skyLightStorage;

        public CombinedChunkLightStorage(int minY, int maxY) {
            this.blockLightStorage = ChunkLightStorage.createBlockLightStorage(minY, maxY);
            this.skyLightStorage = ChunkLightStorage.createSkyLightStorage(minY, maxY);
        }
    }
}

