/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionTypeWrapper
implements IDimensionTypeWrapper {
    private static final ConcurrentMap<String, DimensionTypeWrapper> DIMENSION_WRAPPER_BY_NAME = new ConcurrentHashMap<String, DimensionTypeWrapper>();
    private final DimensionType dimensionType;
    private final String name;

    public DimensionTypeWrapper(DimensionType dimensionType, String name) {
        this.dimensionType = dimensionType;
        this.name = name;
    }

    public static DimensionTypeWrapper getDimensionTypeWrapper(DimensionType dimensionType, String name) {
        String dimName = name;
        if (DIMENSION_WRAPPER_BY_NAME.containsKey(dimName) && DIMENSION_WRAPPER_BY_NAME.get(dimName) != null) {
            return (DimensionTypeWrapper)DIMENSION_WRAPPER_BY_NAME.get(dimName);
        }
        DimensionTypeWrapper dimensionTypeWrapper = new DimensionTypeWrapper(dimensionType, dimName);
        DIMENSION_WRAPPER_BY_NAME.put(dimName, dimensionTypeWrapper);
        return dimensionTypeWrapper;
    }

    private static String determineName(DimensionType dimensionType) {
        throw new UnsupportedOperationException("As of MC 1.21.11 the dimension type no longer stores it's name and must be determined from the level.");
    }

    public static void clearMap() {
        DIMENSION_WRAPPER_BY_NAME.clear();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasCeiling() {
        return this.dimensionType.hasCeiling();
    }

    @Override
    public boolean hasSkyLight() {
        return this.dimensionType.hasSkyLight();
    }

    @Override
    public Object getWrappedMcObject() {
        return this.dimensionType;
    }

    @Override
    public boolean isTheEnd() {
        return this.getName().equalsIgnoreCase("the_end");
    }

    @Override
    public double getCoordinateScale() {
        return this.dimensionType.coordinateScale();
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != DimensionTypeWrapper.class) {
            return false;
        }
        DimensionTypeWrapper other = (DimensionTypeWrapper)obj;
        return other.getName().equals(this.getName());
    }
}

