/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.config.util;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.balm.platform.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.platform.config.schema.ConfiguredEnum;
import net.blay09.mods.balm.platform.config.schema.ConfiguredList;
import net.blay09.mods.balm.platform.config.schema.ConfiguredProperty;
import net.blay09.mods.balm.platform.config.schema.ConfiguredSet;
import net.blay09.mods.balm.platform.config.schema.builder.ConfigCategory;
import org.jspecify.annotations.Nullable;

public class ConfigJsonExport {
    public static ExportedConfig mapToExportData(Collection<BalmConfigSchema> schemas) {
        ArrayList<ConfigProperty> properties = new ArrayList<ConfigProperty>();
        for (BalmConfigSchema schema : schemas) {
            for (ConfiguredProperty<?> property : schema.rootProperties()) {
                properties.add(new ConfigProperty(property));
            }
            for (ConfigCategory category : schema.categories()) {
                for (ConfiguredProperty<?> property : category.properties()) {
                    properties.add(new ConfigProperty(property));
                }
            }
        }
        return new ExportedConfig(properties);
    }

    public static void exportToFile(Collection<BalmConfigSchema> schemas, File file) throws IOException {
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Failed to create parent directories for file: " + String.valueOf(file));
        }
        Files.writeString(file.toPath(), (CharSequence)new Gson().toJson((Object)ConfigJsonExport.mapToExportData(schemas)), new OpenOption[0]);
    }

    private static String @Nullable [] getValidValues(ConfiguredProperty<?> property) {
        Class<Object> enumType = null;
        ConfiguredProperty<?> configuredProperty = property;
        Objects.requireNonNull(configuredProperty);
        ConfiguredProperty<?> configuredProperty2 = configuredProperty;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConfiguredEnum.class, ConfiguredList.class, ConfiguredSet.class}, configuredProperty2, n)) {
                case 0: {
                    ConfiguredEnum enumProperty = (ConfiguredEnum)configuredProperty2;
                    enumType = enumProperty.type();
                    break block5;
                }
                case 1: {
                    ConfiguredList listProperty = (ConfiguredList)configuredProperty2;
                    if (!listProperty.nestedType().isEnum()) {
                        n = 2;
                        continue block5;
                    }
                    enumType = listProperty.nestedType();
                    break block5;
                }
                case 2: {
                    ConfiguredSet setProperty = (ConfiguredSet)configuredProperty2;
                    if (!setProperty.nestedType().isEnum()) {
                        n = 3;
                        continue block5;
                    }
                    enumType = setProperty.nestedType();
                    break block5;
                }
            }
            break;
        }
        if (enumType != null) {
            return (String[])Arrays.stream(enumType.getEnumConstants()).map(Object::toString).toArray(String[]::new);
        }
        return null;
    }

    public record ConfigProperty(String configType, String category, String name, String type, String description, String defaultValue, String @Nullable [] validValues) {
        public ConfigProperty(ConfiguredProperty<?> property) {
            this(property.parentSchema().identifier().method_12832(), property.category(), property.name(), property.type().getSimpleName(), property.comment(), Objects.toString(property.defaultValue()), ConfigJsonExport.getValidValues(property));
        }
    }

    public record ExportedConfig(List<ConfigProperty> properties) {
    }
}

