/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.frames;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import de.dafuqs.paginatedadvancements.frames.FrameWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7654;
import org.jetbrains.annotations.Nullable;

public class AdvancementFrameDataLoader
extends class_4309<List<Entry>>
implements IdentifiableResourceReloadListener {
    public static final String LOCATION = "advancement_frames";
    public static final class_2960 ID = PaginatedAdvancementsClient.locate("advancement_frames");
    public static final AdvancementFrameDataLoader INSTANCE = new AdvancementFrameDataLoader();
    protected static final Map<class_2960, FrameWrapper> CUSTOM_FRAMES = new HashMap<class_2960, FrameWrapper>();

    public AdvancementFrameDataLoader() {
        super(Entry.LIST_CODEC, class_7654.method_45114((String)LOCATION));
    }

    @Nullable
    public static FrameWrapper get(class_2960 id) {
        return CUSTOM_FRAMES.getOrDefault(id, null);
    }

    protected Map<class_2960, List<Entry>> method_20731(class_3300 resourceManager, class_3695 profiler) {
        return super.method_20731(resourceManager, profiler);
    }

    protected void apply(Map<class_2960, List<Entry>> prepared, class_3300 manager, class_3695 profiler) {
        for (Map.Entry<class_2960, List<Entry>> list : prepared.entrySet()) {
            for (Entry entry : list.getValue()) {
                class_2960 advancement = entry.advancementId();
                class_2960 frame = entry.frameId();
                @Nullable FrameWrapper frameWrapper = FrameWrapper.of(frame);
                if (frameWrapper == null) {
                    PaginatedAdvancementsClient.LOGGER.error("Advancement Frame '{}' for advancement  '{}' is unknown.", (Object)frame, (Object)advancement);
                    continue;
                }
                CUSTOM_FRAMES.put(advancement, frameWrapper);
            }
        }
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public record Entry(class_2960 advancementId, class_2960 frameId) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("advancement").forGetter(Entry::advancementId), (App)class_2960.field_25139.fieldOf("frame").forGetter(Entry::frameId)).apply((Applicative)instance, Entry::new));
        public static final Codec<List<Entry>> LIST_CODEC = CODEC.listOf();
    }
}

