/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.teamresourceful.resourcefullib.common.codecs.PrimitiveCodecHelper;
import com.teamresourceful.resourcefullib.common.collections.WeightedCollection;
import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import net.minecraft.class_2378;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public final class CodecExtras {
    public static final Codec<Double> NON_NEGATIVE_DOUBLE = CodecExtras.doubleRangeWithMessage(0.0, Double.MAX_VALUE, aDouble -> "Value must be greater than or equal to 0. Found: " + aDouble);
    public static final Codec<Double> POSITIVE_DOUBLE = CodecExtras.doubleRangeWithMessage(1.0, Double.MAX_VALUE, aDouble -> "Value must be greater than 0. Found: " + aDouble);
    public static final Codec<Double> NON_POSITIVE_DOUBLE = CodecExtras.doubleRangeWithMessage(Double.MIN_VALUE, 0.0, aDouble -> "Value must be less than or equal to 0. Found: " + aDouble);
    public static final Codec<Double> NEGATIVE_DOUBLE = CodecExtras.doubleRangeWithMessage(Double.MIN_VALUE, -1.0, aDouble -> "Value must be less than 0. Found: " + aDouble);
    public static final Codec<Double> DOUBLE_UNIT_INTERVAL = CodecExtras.doubleRangeWithMessage(0.0, 1.0, aDouble -> "Value must be between 0 and 1. Found: " + aDouble);
    public static final Codec<Float> NON_NEGATIVE_FLOAT = CodecExtras.floatRangeWithMessage(0.0f, Float.MAX_VALUE, aFloat -> "Value must be greater than or equal to 0. Found: " + aFloat);
    public static final Codec<Float> POSITIVE_FLOAT = CodecExtras.floatRangeWithMessage(1.0f, Float.MAX_VALUE, aFloat -> "Value must be greater than 0. Found: " + aFloat);
    public static final Codec<Float> NON_POSITIVE_FLOAT = CodecExtras.floatRangeWithMessage(Float.MIN_VALUE, 0.0f, aFloat -> "Value must be less than or equal to 0. Found: " + aFloat);
    public static final Codec<Float> NEGATIVE_FLOAT = CodecExtras.floatRangeWithMessage(Float.MIN_VALUE, -1.0f, aFloat -> "Value must be less than 0. Found: " + aFloat);
    public static final Codec<Float> FLOAT_UNIT_INTERVAL = CodecExtras.floatRangeWithMessage(0.0f, 1.0f, aFloat -> "Value must be between 0 and 1. Found: " + aFloat);
    public static final Codec<Integer> NON_NEGATIVE_INT = class_5699.field_33441;
    public static final Codec<Integer> POSITIVE_INT = class_5699.field_33442;
    public static final Codec<Integer> NON_POSITIVE_INT = CodecExtras.intRangeWithMessage(Integer.MIN_VALUE, 0, integer -> "Value must be less than or equal to 0. Found: " + integer);
    public static final Codec<Integer> NEGATIVE_INT = CodecExtras.intRangeWithMessage(Integer.MIN_VALUE, -1, integer -> "Value must be less than 0. Found: " + integer);
    public static final Codec<Integer> INT_UNIT_INTERVAL = CodecExtras.intRangeWithMessage(0, 1, integer -> "Value must be between 0 and 1. Found: " + integer);
    public static final PrimitiveCodec<Number> NUMBER = PrimitiveCodecHelper.create(DynamicOps::getNumberValue, DynamicOps::createNumeric, "Number");

    private CodecExtras() throws UtilityClassException {
        throw new UtilityClassException();
    }

    public static <O, A> Function<O, Optional<A>> optionalFor(Function<O, @Nullable A> getter) {
        return o -> Optional.ofNullable(getter.apply(o));
    }

    public static <T> Codec<WeightedCollection<T>> weightedCollection(Codec<T> codec, ToDoubleFunction<T> weighter) {
        return codec.listOf().xmap(set -> WeightedCollection.of(set, weighter), collection -> collection.stream().toList());
    }

    public static <T> Codec<T> registryId(class_2378<T> registry) {
        return Codec.INT.comapFlatMap(value -> {
            Object t = registry.method_10200(value.intValue());
            if (t == null) {
                return DataResult.error(() -> "Unknown registry value: " + value);
            }
            return DataResult.success((Object)t);
        }, arg_0 -> registry.method_10206(arg_0));
    }

    public static <T> Codec<Set<T>> set(Codec<T> codec) {
        return codec.listOf().xmap(HashSet::new, ArrayList::new);
    }

    public static <T> Codec<Set<T>> linkedSet(Codec<T> codec) {
        return codec.listOf().xmap(LinkedHashSet::new, LinkedList::new);
    }

    public static <T> Codec<T> passthrough(Function<T, JsonElement> encoder, Function<JsonElement, T> decoder) {
        return Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
            Object patt0$temp = dynamic.getValue();
            if (patt0$temp instanceof JsonElement) {
                JsonElement jsonElement = (JsonElement)patt0$temp;
                JsonElement output = CodecExtras.clearNulls(jsonElement);
                if (output == null) {
                    return DataResult.error(() -> "Value was null for decoder: " + String.valueOf(decoder));
                }
                return DataResult.success(decoder.apply(output));
            }
            return DataResult.error(() -> "Value was not an instance of JsonElement");
        }, input -> new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)CodecExtras.clearNulls((JsonElement)encoder.apply(input))));
    }

    public static <S> Codec<S> eitherRight(Codec<Either<S, S>> eitherCodec) {
        return eitherCodec.xmap(e -> e.map(p -> p, p -> p), Either::right);
    }

    public static <S> Codec<S> eitherLeft(Codec<Either<S, S>> eitherCodec) {
        return eitherCodec.xmap(e -> e.map(p -> p, p -> p), Either::left);
    }

    private static JsonElement clearNulls(JsonElement json) {
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            JsonObject newObject = new JsonObject();
            for (String key : object.keySet()) {
                JsonElement element = CodecExtras.clearNulls(object.get(key));
                if (element == null) continue;
                newObject.add(key, element);
            }
            return newObject;
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            JsonArray newArray = new JsonArray();
            for (JsonElement item : array) {
                JsonElement element = CodecExtras.clearNulls(item);
                if (element == null) continue;
                newArray.add(element);
            }
            return newArray;
        }
        return json.isJsonNull() ? null : json;
    }

    private static Codec<Integer> intRangeWithMessage(int i, int j, Function<Integer, String> function) {
        return Codec.INT.validate(integer -> integer.compareTo(i) >= 0 && integer.compareTo(j) <= 0 ? DataResult.success((Object)integer) : DataResult.error(() -> (String)function.apply((Integer)integer)));
    }

    private static Codec<Double> doubleRangeWithMessage(double i, double j, Function<Double, String> function) {
        return Codec.DOUBLE.validate(aDouble -> aDouble.compareTo(i) >= 0 && aDouble.compareTo(j) <= 0 ? DataResult.success((Object)aDouble) : DataResult.error(() -> (String)function.apply((Double)aDouble)));
    }

    private static Codec<Float> floatRangeWithMessage(float i, float j, Function<Float, String> function) {
        return Codec.FLOAT.validate(aFloat -> aFloat.compareTo(Float.valueOf(i)) >= 0 && aFloat.compareTo(Float.valueOf(j)) <= 0 ? DataResult.success((Object)aFloat) : DataResult.error(() -> (String)function.apply((Float)aFloat)));
    }
}

