/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.nbt.validators.numeric;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import com.teamresourceful.resourcefullib.common.nbt.validators.numeric.NumericValidator;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import net.minecraft.class_2481;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;

public record BetweenNumericValidator(Optional<Number> min, Optional<Number> max) implements NumericValidator
{
    public static final String ID = "number:between";
    public static final Codec<BetweenNumericValidator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecExtras.NUMBER.optionalFieldOf("min").forGetter(BetweenNumericValidator::min), (App)CodecExtras.NUMBER.optionalFieldOf("max").forGetter(BetweenNumericValidator::max)).apply((Applicative)instance, BetweenNumericValidator::new));

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean test(class_2514 tag) {
        class_2514 class_25142 = tag;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2481.class, class_2516.class, class_2497.class, class_2503.class, class_2494.class, class_2489.class}, (Object)class_25142, n)) {
            case 0 -> {
                class_2481 byteTag = (class_2481)class_25142;
                byte min = this.min.map(Number::byteValue).orElse((byte)-128);
                byte max = this.max.map(Number::byteValue).orElse((byte)127);
                if (byteTag.comp_3817() >= min && byteTag.comp_3817() <= max) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                class_2516 shortTag = (class_2516)class_25142;
                short min = this.min.map(Number::shortValue).orElse((short)Short.MIN_VALUE);
                short max = this.max.map(Number::shortValue).orElse((short)Short.MAX_VALUE);
                if (shortTag.comp_3822() >= min && shortTag.comp_3822() <= max) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                class_2497 intTag = (class_2497)class_25142;
                int min = this.min.map(Number::intValue).orElse(Integer.MIN_VALUE);
                int max = this.max.map(Number::intValue).orElse(Integer.MAX_VALUE);
                if (intTag.comp_3820() >= min && intTag.comp_3820() <= max) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                class_2503 longTag = (class_2503)class_25142;
                long min = this.min.map(Number::longValue).orElse(Long.MIN_VALUE);
                long max = this.max.map(Number::longValue).orElse(Long.MAX_VALUE);
                if (longTag.comp_3821() >= min && longTag.comp_3821() <= max) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                class_2494 floatTag = (class_2494)class_25142;
                float min = this.min.map(Number::floatValue).orElse(Float.valueOf(Float.MIN_VALUE)).floatValue();
                float max = this.max.map(Number::floatValue).orElse(Float.valueOf(Float.MAX_VALUE)).floatValue();
                if (floatTag.comp_3819() >= min && floatTag.comp_3819() <= max) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                class_2489 doubleTag = (class_2489)class_25142;
                double min = this.min.map(Number::doubleValue).orElse((Double)Double.MIN_VALUE);
                double max = this.max.map(Number::doubleValue).orElse((Double)Double.MAX_VALUE);
                if (doubleTag.comp_3818() >= min && doubleTag.comp_3818() <= max) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

