/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.fabric;

import com.teamresourceful.resourcefullib.common.lib.Constants;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.fabric.api.resource.v1.pack.PackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8144;
import org.jetbrains.annotations.Nullable;

public final class FabricResourcePackHandler {
    private static final String RESOURCE_PACK_KEY = "resourcefullib:resourcepack";

    public static void load() {
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata metadata = mod.getMetadata();
            if (!metadata.containsCustomValue(RESOURCE_PACK_KEY)) continue;
            try {
                FabricResourcePackHandler.initMod(mod, metadata);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Resourceful Lib failed to load resource pack for mod: {}", (Object)metadata.getName(), (Object)e);
            }
        }
    }

    private static void initMod(ModContainer mod, ModMetadata metadata) {
        CustomValue.CvArray packs = metadata.getCustomValue(RESOURCE_PACK_KEY).getAsArray();
        for (CustomValue pack : packs) {
            FabricResourcePackHandler.loadPack(mod, pack);
        }
    }

    private static void loadPack(ModContainer container, CustomValue value) {
        try {
            String name = value.getAsString();
            ResourceLoader.registerBuiltinPack((class_2960)class_2960.method_60655((String)container.getMetadata().getId(), (String)name), (ModContainer)container, (class_2561)FabricResourcePackHandler.createDescription(null, name), (PackActivationType)PackActivationType.NORMAL);
        }
        catch (Exception ignored) {
            CustomValue.CvObject object = value.getAsObject();
            String name = object.get("name").getAsString();
            class_2960 id = class_2960.method_60655((String)container.getMetadata().getId(), (String)name);
            class_2561 description = FabricResourcePackHandler.createDescription((String)class_8144.method_49077((Object)object.get("description"), CustomValue::getAsString), name);
            PackActivationType type = (Boolean)class_8144.method_49078((Object)object.get("required"), CustomValue::getAsBoolean, (Object)false) != false ? PackActivationType.ALWAYS_ENABLED : PackActivationType.NORMAL;
            ResourceLoader.registerBuiltinPack((class_2960)id, (ModContainer)container, (class_2561)description, (PackActivationType)type);
        }
    }

    private static class_2561 createDescription(@Nullable String description, String name) {
        if (description != null) {
            return class_2561.method_43470((String)description);
        }
        return class_2561.method_48321((String)("resourcefullib.resourcepack." + name), (String)name);
    }
}

