/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import fuzs.pickupnotifier.config.ClientConfig;
import fuzs.pickupnotifier.config.CombineEntries;
import net.minecraft.class_10799;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9848;

public final class ExperienceDisplayEntry
extends DisplayEntry<class_2561> {
    private static final class_2960 EXPERIENCE_ORB_TEXTURES = class_2960.method_60656((String)"textures/entity/experience_orb.png");
    private int tickCount;

    public ExperienceDisplayEntry(class_2561 name, int displayAmount, int tickCount) {
        super(name, displayAmount, class_1814.field_8907);
        this.tickCount = tickCount;
    }

    @Override
    protected class_2561 getEntryName(class_2561 component) {
        return component;
    }

    @Override
    public void tick() {
        super.tick();
        ++this.tickCount;
    }

    @Override
    public DisplayEntry<?> mergeWith(DisplayEntry<?> otherDisplayEntry) {
        return new ExperienceDisplayEntry((class_2561)this.item, this.getDisplayAmount() + otherDisplayEntry.getDisplayAmount(), this.tickCount);
    }

    @Override
    protected void renderSprite(class_332 guiGraphics, class_327 font, int posX, int posY, float alpha) {
        int textureOffset = ExperienceDisplayEntry.getXpTexture(this.getDisplayAmount());
        int textureX = textureOffset % 4 * 16;
        int textureY = textureOffset / 4 * 16;
        int textureColor = ExperienceDisplayEntry.getExperienceOrbColor((float)this.tickCount / 2.0f, class_9848.method_61326((float)alpha));
        guiGraphics.method_25293(class_10799.field_56883, EXPERIENCE_ORB_TEXTURES, posX, posY, (float)textureX, (float)textureY, 16, 16, 16, 16, 64, 64, textureColor);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.combineEntries != CombineEntries.NEVER) {
            return obj instanceof ExperienceDisplayEntry;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31;
    }

    private static int getExperienceOrbColor(float ageInTicks, int alpha) {
        int red = class_9848.method_61326((float)((class_3532.method_15374((double)ageInTicks) + 1.0f) * 0.5f));
        int green = 255;
        int blue = class_9848.method_61326((float)((class_3532.method_15374((double)(ageInTicks + 4.1887903f)) + 1.0f) * 0.1f));
        return class_9848.method_61324((int)alpha, (int)red, (int)green, (int)blue);
    }

    private static int getXpTexture(int displayCount) {
        if (displayCount >= 2477) {
            return 10;
        }
        if (displayCount >= 1237) {
            return 9;
        }
        if (displayCount >= 617) {
            return 8;
        }
        if (displayCount >= 307) {
            return 7;
        }
        if (displayCount >= 149) {
            return 6;
        }
        if (displayCount >= 73) {
            return 5;
        }
        if (displayCount >= 37) {
            return 4;
        }
        if (displayCount >= 17) {
            return 3;
        }
        if (displayCount >= 7) {
            return 2;
        }
        if (displayCount >= 3) {
            return 1;
        }
        return 0;
    }
}

