/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.handler;

import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import fuzs.pickupnotifier.client.gui.entry.ExperienceDisplayEntry;
import fuzs.pickupnotifier.client.gui.entry.ItemDisplayEntry;
import fuzs.pickupnotifier.client.handler.DrawEntriesHandler;
import fuzs.pickupnotifier.config.ClientConfig;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jspecify.annotations.Nullable;

public class AddEntriesHandler {
    public static void onEntityPickup(class_638 clientLevel, int entityId, int playerId, int amount) {
        if (clientLevel.method_8469(playerId) instanceof class_746 && !DrawEntriesHandler.INSTANCE.isItemEntityHandled(entityId)) {
            AddEntriesHandler.onEntityPickup(clientLevel, entityId, amount);
        }
    }

    public static void addPickUpEntry(class_638 clientLevel, int entityId, int amount) {
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.clientOnly) {
            DrawEntriesHandler.INSTANCE.addHandledEntity(entityId);
            AddEntriesHandler.onEntityPickup(clientLevel, entityId, amount);
        }
    }

    public static void addItemEntry(class_1799 itemStack) {
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.clientOnly && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.includeItems) {
            AddEntriesHandler.addItemEntry(itemStack, itemStack.method_7947());
        }
    }

    private static void onEntityPickup(class_638 clientLevel, int itemId, int amount) {
        class_1297 entity = clientLevel.method_8469(itemId);
        if (entity instanceof class_1542) {
            class_1542 item = (class_1542)entity;
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.includeItems) {
                AddEntriesHandler.addItemEntry(item.method_6983(), amount);
            }
        } else if (entity instanceof class_1665) {
            class_1665 abstractArrow = (class_1665)entity;
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.includeArrows) {
                AddEntriesHandler.addItemEntry(abstractArrow.method_54759(), amount);
            }
        } else if (entity instanceof class_1303) {
            class_1303 experience = (class_1303)entity;
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.includeExperience) {
                AddEntriesHandler.addExperienceEntry(experience, amount);
            }
        }
    }

    private static void addItemEntry(@Nullable class_1799 itemStack, int amount) {
        if (itemStack != null && !itemStack.method_7960() && !((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.hiddenItems.contains((Object)itemStack.method_7909())) {
            AddEntriesHandler.addEntry(new ItemDisplayEntry(itemStack, amount));
        }
    }

    private static void addExperienceEntry(class_1303 orb, int amount) {
        if (orb.method_5919() > 0) {
            if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.experienceValue) {
                amount = orb.method_5919();
            }
            AddEntriesHandler.addEntry(new ExperienceDisplayEntry(orb.method_5477(), amount, orb.field_6012));
        }
    }

    private static void addEntry(DisplayEntry<?> displayEntry) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 != null && minecraft.field_1724.method_31549().field_7477 && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).general.disableInCreative) {
            return;
        }
        int scaledHeight = (int)((float)minecraft.method_22683().method_4502() / ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.getDisplayScale());
        int maxSize = (int)((double)scaledHeight * ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.maxHeight / 18.0) - 1;
        Map<Object, DisplayEntry<?>> collector = DrawEntriesHandler.INSTANCE.getCollector();
        DisplayEntry<?> oldDisplayEntry = collector.remove(displayEntry.getKey());
        if (oldDisplayEntry != null) {
            displayEntry = displayEntry.mergeWith(oldDisplayEntry);
        }
        if (!collector.isEmpty() && collector.size() >= maxSize) {
            Iterator<Map.Entry<Object, DisplayEntry<?>>> iterator = collector.entrySet().iterator();
            iterator.next();
            iterator.remove();
        }
        collector.put(displayEntry.getKey(), displayEntry);
    }
}

