/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jspecify.annotations.Nullable;
import snownee.jade.JadeClient;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.track.HealthTrackInfo;

public class HealthElement
extends Element {
    private class_329.class_6411 heartType;
    private final float maxHealth;
    private final float health;
    private final float absorption;
    private @Nullable String text;
    private int iconsPerLine = 1;
    private int lineCount = 1;
    private int iconCount = 1;
    private @Nullable HealthTrackInfo track;

    public HealthElement(class_329.class_6411 heartType, float maxHealth, float health, float absorption) {
        this.heartType = heartType;
        this.maxHealth = maxHealth;
        this.health = health;
        this.absorption = absorption;
        IPluginConfig config = IWailaConfig.get().plugin();
        int iconCount = class_3532.method_15386((float)maxHealth) + class_3532.method_15386((float)absorption);
        if (iconCount > config.getInt(JadeIds.MC_ENTITY_HEALTH_MAX_FOR_RENDER)) {
            health += absorption;
            if (!config.get(JadeIds.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
                maxHealth = class_3532.method_15386((float)maxHealth);
                health = class_3532.method_15386((float)health);
            }
            if (absorption > 0.0f) {
                this.heartType = class_329.class_6411.field_33948;
            }
            this.text = String.format("%s/%s", DisplayHelper.dfCommas.format(health), DisplayHelper.dfCommas.format(maxHealth));
        } else {
            int maxHeartsPerLine = config.getInt(JadeIds.MC_ENTITY_HEALTH_ICONS_PER_LINE);
            this.iconCount = iconCount = class_3532.method_15386((float)((float)iconCount * 0.5f));
            this.iconsPerLine = Math.min(maxHeartsPerLine, iconCount);
            this.lineCount = class_3532.method_15386((float)((float)iconCount / (float)maxHeartsPerLine));
        }
        if (this.showText()) {
            this.width = DisplayHelper.font().method_1727(this.text) + 10;
            this.height = 9;
        } else {
            this.width = 8 * this.iconsPerLine + 1;
            this.height = 5 + 4 * this.lineCount;
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        float health;
        float lastHealth = health = this.health * 0.5f;
        float lastAbsorption = this.absorption;
        boolean blink = false;
        if (this.track == null && this.getTag() != null) {
            this.track = JadeClient.tickHandler().progressTracker.getOrCreate(this.getTag(), HealthTrackInfo.class, () -> new HealthTrackInfo(this.health, this.absorption));
        }
        if (this.track != null) {
            this.track.setHealth(this.health, this.absorption);
            this.track.update(class_310.method_1551().method_61966().method_60638());
            lastHealth = this.track.getLastHealth() * 0.5f;
            lastAbsorption = this.track.getLastAbsorption();
            blink = this.track.isBlinking();
        }
        IDisplayHelper helper = IDisplayHelper.get();
        int xOffset = (this.iconCount - 1) % this.iconsPerLine * 8;
        int yOffset = this.lineCount * 4 - 4;
        class_2960 containerSprite = class_329.class_6411.field_33944.method_52705(false, false, blink);
        for (int i = this.iconCount; i > 0; --i) {
            int xPos = this.method_46426() + xOffset;
            int yPos = this.method_46427() + yOffset;
            helper.blitSprite(graphics, class_10799.field_56883, containerSprite, xPos, yPos, 9, 9);
            boolean renderAbsorb = i > class_3532.method_15386((float)(this.maxHealth * 0.5f));
            class_329.class_6411 curHeart = this.heartType;
            float curHealth = health;
            float curLastHealth = lastHealth;
            if (renderAbsorb) {
                curHeart = class_329.class_6411.field_33948;
                curHealth = ((float)class_3532.method_15386((float)this.maxHealth) + this.absorption) * 0.5f;
                curLastHealth = ((float)class_3532.method_15386((float)this.maxHealth) + lastAbsorption) * 0.5f;
            }
            if (i <= class_3532.method_15375((float)curHealth)) {
                helper.blitSprite(graphics, class_10799.field_56883, curHeart.method_52705(false, false, false), xPos, yPos, 9, 9);
            }
            if ((float)i > curHealth) {
                if (i <= class_3532.method_15375((float)curLastHealth)) {
                    helper.blitSprite(graphics, class_10799.field_56883, curHeart.method_52705(false, false, true), xPos, yPos, 9, 9);
                } else if ((float)i > curLastHealth && (float)i < curLastHealth + 1.0f) {
                    helper.blitSprite(graphics, class_10799.field_56883, curHeart.method_52705(false, true, true), xPos, yPos, 9, 9);
                }
                if ((float)i < curHealth + 1.0f) {
                    helper.blitSprite(graphics, class_10799.field_56883, curHeart.method_52705(false, true, false), xPos, yPos, 9, 9);
                }
            }
            if ((xOffset -= 8) >= 0) continue;
            xOffset = this.iconsPerLine * 8 - 8;
            yOffset -= 4;
        }
        if (this.showText()) {
            helper.drawText(graphics, Objects.requireNonNull(this.text), (float)(this.method_46426() + 10), (float)(this.method_46427() + 1), IThemeHelper.get().getNormalColor());
        }
    }

    @Override
    public class_2561 getNarration() {
        return class_2561.method_43469((String)"narration.jade.health", (Object[])new Object[]{class_3532.method_15386((float)this.health)});
    }

    public boolean showText() {
        return this.text != null;
    }
}

