/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.veinminer.config;

import de.miraculixx.veinminer.config.ConfigSerializer;
import de.miraculixx.veinminer.config.ResourceLocationSerializer;
import de.miraculixx.veinminer.config.data.BlockGroup;
import de.miraculixx.veinminer.config.data.VeinminerSettings;
import de.miraculixx.veinminer.config.utils.GlobalsKt;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.LinkedHashSetSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModuleBuilder;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\u000f\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u000f\u0010\u0011\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0003J\u000f\u0010\u0012\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0003R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR$\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u000fR0\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020 0\u001f8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R0\u0010'\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020&0%8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b'\u0010\"\u001a\u0004\b(\u0010$R<\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0)0\u001f2\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0)0\u001f8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b*\u0010\"\u001a\u0004\b+\u0010$R<\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0)0%2\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0)0%8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b,\u0010\"\u001a\u0004\b-\u0010$\u00a8\u0006."}, d2={"Lde/miraculixx/veinminer/config/ConfigManager;", "", "<init>", "()V", "", "fromDisc", "", "reload", "(Z)V", "save", "loadBlocks", "(Z)Z", "loadGroups", "Lde/miraculixx/veinminer/config/data/VeinminerSettings;", "loadSettings", "()Lde/miraculixx/veinminer/config/data/VeinminerSettings;", "saveBlocks", "saveGroups", "saveSettings", "Ljava/nio/file/Path;", "settingsFile", "Ljava/nio/file/Path;", "blocksFile", "groupsFile", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "value", "settings", "Lde/miraculixx/veinminer/config/data/VeinminerSettings;", "getSettings", "", "", "veinBlocksRaw", "Ljava/util/Set;", "getVeinBlocksRaw", "()Ljava/util/Set;", "", "Lnet/minecraft/class_2960;", "veinBlocks", "getVeinBlocks", "Lde/miraculixx/veinminer/config/data/BlockGroup;", "groupsRaw", "getGroupsRaw", "groups", "getGroups", "veinminer-fabric"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\nde/miraculixx/veinminer/config/ConfigManager\n+ 2 PathExtensions.kt\nde/miraculixx/veinminer/config/extensions/PathExtensionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 SerializersModuleBuilders.kt\nkotlinx/serialization/modules/SerializersModuleBuildersKt\n*L\n1#1,108:1\n15#2,3:109\n18#2,7:113\n25#2,3:121\n15#2,3:125\n18#2,7:129\n25#2,3:137\n14#2,4:142\n18#2,7:147\n25#2,3:155\n205#3:112\n222#3:120\n222#3:124\n205#3:128\n222#3:136\n205#3:146\n222#3:154\n205#3:158\n205#3:159\n205#3:160\n1869#4,2:140\n31#5,3:161\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\nde/miraculixx/veinminer/config/ConfigManager\n*L\n69#1:109,3\n69#1:113,7\n69#1:121,3\n83#1:125,3\n83#1:129,7\n83#1:137,3\n103#1:142,4\n103#1:147,7\n103#1:155,3\n69#1:112\n69#1:120\n82#1:124\n83#1:128\n83#1:136\n103#1:146\n103#1:154\n105#1:158\n106#1:159\n107#1:160\n88#1:140,2\n21#1:161,3\n*E\n"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    @NotNull
    private static final Path settingsFile;
    @NotNull
    private static final Path blocksFile;
    @NotNull
    private static final Path groupsFile;
    @NotNull
    private static final Json json;
    @NotNull
    private static VeinminerSettings settings;
    @NotNull
    private static Set<String> veinBlocksRaw;
    @NotNull
    private static Set<class_2960> veinBlocks;
    @NotNull
    private static Set<BlockGroup<String>> groupsRaw;
    @NotNull
    private static Set<BlockGroup<class_2960>> groups;

    private ConfigManager() {
    }

    @NotNull
    public final VeinminerSettings getSettings() {
        return settings;
    }

    @NotNull
    public final Set<String> getVeinBlocksRaw() {
        return veinBlocksRaw;
    }

    @NotNull
    public final Set<class_2960> getVeinBlocks() {
        return veinBlocks;
    }

    @NotNull
    public final Set<BlockGroup<String>> getGroupsRaw() {
        return groupsRaw;
    }

    @NotNull
    public final Set<BlockGroup<class_2960>> getGroups() {
        return groups;
    }

    public final void reload(boolean fromDisc) {
        if (fromDisc) {
            settings = this.loadSettings();
        }
        if (this.loadBlocks(fromDisc)) {
            this.saveBlocks();
        }
        if (this.loadGroups(fromDisc)) {
            this.saveGroups();
        }
    }

    public final void save() {
        this.loadBlocks(false);
        this.loadGroups(false);
        this.saveSettings();
        this.saveBlocks();
        this.saveGroups();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean loadBlocks(boolean fromDisc) {
        boolean bl;
        if (fromDisc) {
            void v1;
            void $this$load$iv;
            Path path = blocksFile;
            Set set = new LinkedHashSet();
            Json instance$iv = json;
            boolean $i$f$load = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists((Path)$this$load$iv, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                PathsKt.createParentDirectories((Path)$this$load$iv, (FileAttribute[])new FileAttribute[0]);
                Json this_$iv$iv = instance$iv;
                boolean $i$f$encodeToString = false;
                this_$iv$iv.getSerializersModule();
                String string$iv = this_$iv$iv.encodeToString((SerializationStrategy)new LinkedHashSetSerializer((KSerializer)StringSerializer.INSTANCE), (Object)default$iv);
                PathsKt.writeText$default((Path)$this$load$iv, (CharSequence)string$iv, null, (OpenOption[])new OpenOption[0], (int)2, null);
                System.out.println((Object)("[Veinminer] Created " + $this$load$iv.getFileName() + " default config"));
                if (GlobalsKt.getDebug()) {
                    System.out.println((Object)("[Veinminer] Content: " + string$iv));
                }
                v1 = default$iv;
            } else {
                Object object;
                try {
                    void this_$iv$iv;
                    Json string$iv = instance$iv;
                    String string$iv$iv = PathsKt.readText$default((Path)$this$load$iv, null, (int)1, null);
                    boolean $i$f$decodeFromString = false;
                    this_$iv$iv.getSerializersModule();
                    object = this_$iv$iv.decodeFromString((DeserializationStrategy)new LinkedHashSetSerializer((KSerializer)StringSerializer.INSTANCE), string$iv$iv);
                }
                catch (Exception e$iv) {
                    System.out.println((Object)("[Veinminer] Failed to load " + $this$load$iv.getFileName() + " config: Reason: " + e$iv.getMessage()));
                    object = default$iv;
                }
                v1 = object;
            }
            veinBlocksRaw = (Set)v1;
        }
        ConfigSerializer.ParsedData parsed = ConfigSerializer.INSTANCE.parseList(veinBlocksRaw, ConfigSerializer.MaterialType.BLOCK);
        veinBlocks = parsed.getParsed();
        if (!((Collection)parsed.getInvalid()).isEmpty()) {
            veinBlocksRaw.removeAll((Collection)parsed.getInvalid());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean loadGroups(boolean fromDisc) {
        Set set;
        block10: {
            Set set2;
            void $this$load$iv;
            Object object;
            block12: {
                block11: {
                    if (!fromDisc) break block10;
                    object = this.getClass().getClassLoader().getResourceAsStream("default_groups.json");
                    if (object == null) break block11;
                    byte[] byArray = ((InputStream)object).readAllBytes();
                    object = byArray;
                    if (byArray != null && (object = StringsKt.decodeToString((byte[])object)) != null) break block12;
                }
                object = "[]";
            }
            Object defaultSource = object;
            Object this_$iv = json;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            Set defaultGroups = (Set)this_$iv.decodeFromString((DeserializationStrategy)new LinkedHashSetSerializer(BlockGroup.Companion.serializer((KSerializer)StringSerializer.INSTANCE)), (String)defaultSource);
            this_$iv = groupsFile;
            Json instance$iv = json;
            boolean $i$f$load = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists((Path)$this$load$iv, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                PathsKt.createParentDirectories((Path)$this$load$iv, (FileAttribute[])new FileAttribute[0]);
                Json this_$iv$iv = instance$iv;
                boolean $i$f$encodeToString = false;
                this_$iv$iv.getSerializersModule();
                string$iv = this_$iv$iv.encodeToString((SerializationStrategy)new LinkedHashSetSerializer(BlockGroup.Companion.serializer((KSerializer)StringSerializer.INSTANCE)), (Object)defaultGroups);
                PathsKt.writeText$default((Path)$this$load$iv, (CharSequence)((CharSequence)string$iv), null, (OpenOption[])new OpenOption[0], (int)2, null);
                System.out.println((Object)("[Veinminer] Created " + $this$load$iv.getFileName() + " default config"));
                if (GlobalsKt.getDebug()) {
                    System.out.println((Object)("[Veinminer] Content: " + (String)string$iv));
                }
                set2 = defaultGroups;
            } else {
                Object this_$iv$iv;
                try {
                    string$iv = instance$iv;
                    String string$iv$iv = PathsKt.readText$default((Path)$this$load$iv, null, (int)1, null);
                    boolean $i$f$decodeFromString2 = false;
                    this_$iv$iv.getSerializersModule();
                    this_$iv$iv = this_$iv$iv.decodeFromString((DeserializationStrategy)new LinkedHashSetSerializer(BlockGroup.Companion.serializer((KSerializer)StringSerializer.INSTANCE)), string$iv$iv);
                }
                catch (Exception e$iv) {
                    System.out.println((Object)("[Veinminer] Failed to load " + $this$load$iv.getFileName() + " config: Reason: " + e$iv.getMessage()));
                    this_$iv$iv = defaultGroups;
                }
                set2 = this_$iv$iv;
            }
            groupsRaw = set2;
        }
        boolean save = false;
        Set $this$loadGroups_u24lambda_u243 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = groupsRaw;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockGroup groupRaw = (BlockGroup)element$iv;
            boolean bl2 = false;
            ConfigSerializer.ParsedData parsedBlocks = ConfigSerializer.INSTANCE.parseList(groupRaw.getBlocks(), ConfigSerializer.MaterialType.BLOCK);
            ConfigSerializer.ParsedData parsedTools = ConfigSerializer.INSTANCE.parseList(groupRaw.getTools(), ConfigSerializer.MaterialType.ITEM);
            $this$loadGroups_u24lambda_u243.add(new BlockGroup(groupRaw.getName(), CollectionsKt.toMutableSet((Iterable)parsedBlocks.getParsed()), CollectionsKt.toMutableSet((Iterable)parsedTools.getParsed())));
            if (!(!((Collection)parsedBlocks.getInvalid()).isEmpty()) && !(!((Collection)parsedTools.getInvalid()).isEmpty())) continue;
            groupRaw.getBlocks().removeAll((Collection)parsedBlocks.getInvalid());
            groupRaw.getTools().removeAll((Collection)parsedTools.getInvalid());
            save = true;
        }
        groups = SetsKt.build((Set)set);
        return save;
    }

    /*
     * WARNING - void declaration
     */
    private final VeinminerSettings loadSettings() {
        VeinminerSettings veinminerSettings;
        void $this$load_u24default$iv;
        Path path = settingsFile;
        VeinminerSettings default$iv = new VeinminerSettings(0, false, 0, 0, false, 0, false, false, false, false, null, 2047, null);
        Json instance$iv = GlobalsKt.getJson();
        boolean $i$f$load = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists((Path)$this$load_u24default$iv, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathsKt.createParentDirectories((Path)$this$load_u24default$iv, (FileAttribute[])new FileAttribute[0]);
            Json this_$iv$iv = instance$iv;
            boolean $i$f$encodeToString = false;
            this_$iv$iv.getSerializersModule();
            String string$iv = this_$iv$iv.encodeToString((SerializationStrategy)VeinminerSettings.Companion.serializer(), (Object)default$iv);
            PathsKt.writeText$default((Path)$this$load_u24default$iv, (CharSequence)string$iv, null, (OpenOption[])new OpenOption[0], (int)2, null);
            System.out.println((Object)("[Veinminer] Created " + $this$load_u24default$iv.getFileName() + " default config"));
            if (GlobalsKt.getDebug()) {
                System.out.println((Object)("[Veinminer] Content: " + string$iv));
            }
            veinminerSettings = default$iv;
        } else {
            Object object;
            try {
                void this_$iv$iv;
                Json string$iv = instance$iv;
                String string$iv$iv = PathsKt.readText$default((Path)$this$load_u24default$iv, null, (int)1, null);
                boolean $i$f$decodeFromString = false;
                this_$iv$iv.getSerializersModule();
                object = this_$iv$iv.decodeFromString((DeserializationStrategy)VeinminerSettings.Companion.serializer(), string$iv$iv);
            }
            catch (Exception e$iv) {
                System.out.println((Object)("[Veinminer] Failed to load " + $this$load_u24default$iv.getFileName() + " config: Reason: " + e$iv.getMessage()));
                object = default$iv;
            }
            veinminerSettings = object;
        }
        return veinminerSettings;
    }

    /*
     * WARNING - void declaration
     */
    private final void saveBlocks() {
        void this_$iv;
        Json json = ConfigManager.json;
        Set<String> value$iv = veinBlocksRaw;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        PathsKt.writeText$default((Path)blocksFile, (CharSequence)this_$iv.encodeToString((SerializationStrategy)new LinkedHashSetSerializer((KSerializer)StringSerializer.INSTANCE), value$iv), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void saveGroups() {
        void this_$iv;
        Json json = ConfigManager.json;
        Set<BlockGroup<String>> value$iv = groupsRaw;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        PathsKt.writeText$default((Path)groupsFile, (CharSequence)this_$iv.encodeToString((SerializationStrategy)new LinkedHashSetSerializer(BlockGroup.Companion.serializer((KSerializer)StringSerializer.INSTANCE)), value$iv), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void saveSettings() {
        void this_$iv;
        Json json = ConfigManager.json;
        VeinminerSettings value$iv = settings;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        PathsKt.writeText$default((Path)settingsFile, (CharSequence)this_$iv.encodeToString((SerializationStrategy)VeinminerSettings.Companion.serializer(), (Object)value$iv), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit json$lambda$1(JsonBuilder $this$Json) {
        void $this$json_u24lambda_u241_u24lambda_u240;
        SerializersModuleBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setEncodeDefaults(true);
        boolean $i$f$SerializersModule = false;
        SerializersModuleBuilder serializersModuleBuilder = builder$iv = new SerializersModuleBuilder();
        JsonBuilder jsonBuilder = $this$Json;
        boolean bl = false;
        $this$json_u24lambda_u241_u24lambda_u240.contextual(Reflection.getOrCreateKotlinClass(class_2960.class), (KSerializer)ResourceLocationSerializer.INSTANCE);
        jsonBuilder.setSerializersModule(builder$iv.build());
        return Unit.INSTANCE;
    }

    static {
        Path path = Paths.get("config/Veinminer/settings.json", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        settingsFile = path;
        Path path2 = Paths.get("config/Veinminer/blocks.json", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        blocksFile = path2;
        Path path3 = Paths.get("config/Veinminer/groups.json", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        groupsFile = path3;
        json = JsonKt.Json$default(null, ConfigManager::json$lambda$1, (int)1, null);
        settings = INSTANCE.loadSettings();
        veinBlocksRaw = new LinkedHashSet();
        veinBlocks = SetsKt.emptySet();
        groupsRaw = new LinkedHashSet();
        groups = SetsKt.emptySet();
    }
}

