/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import net.caffeinemc.mods.sodium.api.config.option.SteppedValidator;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.config.ConfigManager;
import net.caffeinemc.mods.sodium.client.config.structure.IntegerOption;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.config.structure.Page;
import net.caffeinemc.mods.sodium.client.data.fingerprint.HashedFingerprint;
import net.caffeinemc.mods.sodium.client.gui.SodiumOptions;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.prompt.ScreenPrompt;
import net.caffeinemc.mods.sodium.client.gui.prompt.ScreenPromptable;
import net.caffeinemc.mods.sodium.client.gui.screen.ConfigCorruptedScreen;
import net.caffeinemc.mods.sodium.client.gui.widgets.DonationButtonWidget;
import net.caffeinemc.mods.sodium.client.gui.widgets.FlatButtonWidget;
import net.caffeinemc.mods.sodium.client.gui.widgets.OptionListWidget;
import net.caffeinemc.mods.sodium.client.gui.widgets.PageListWidget;
import net.caffeinemc.mods.sodium.client.gui.widgets.ScrollableTooltip;
import net.caffeinemc.mods.sodium.client.gui.widgets.SearchWidget;
import net.caffeinemc.mods.sodium.client.services.PlatformRuntimeInformation;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_446;
import net.minecraft.class_5348;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class VideoSettingsScreen
extends class_437
implements ScreenPromptable,
ScrollableTooltip.TooltipParent {
    private final class_437 prevScreen;
    private Dim2i dim;
    private boolean insetX;
    private boolean insetY;
    private PageListWidget pageList;
    private SearchWidget searchWidget;
    private OptionListWidget optionList;
    private FlatButtonWidget applyButton;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget undoButton;
    private DonationButtonWidget donateButton;
    private boolean hasPendingChanges;
    private final ScrollableTooltip tooltip = new ScrollableTooltip(this);
    private @Nullable ScreenPrompt prompt;
    private static final List<class_5348> DONATION_PROMPT_MESSAGE = List.of(class_5348.method_29433((class_5348[])new class_5348[]{class_2561.method_43470((String)"Hello!")}), class_5348.method_29433((class_5348[])new class_5348[]{class_2561.method_43470((String)"It seems that you've been enjoying "), class_2561.method_43470((String)"Sodium").method_54663(2616210), class_2561.method_43470((String)", the powerful and open rendering optimization mod for Minecraft.")}), class_5348.method_29433((class_5348[])new class_5348[]{class_2561.method_43470((String)"Mods like these are complex. They require "), class_2561.method_43470((String)"thousands of hours").method_54663(16739840), class_2561.method_43470((String)" of development, debugging, and tuning to create the experience that players have come to expect.")}), class_5348.method_29433((class_5348[])new class_5348[]{class_2561.method_43470((String)"If you'd like to show your token of appreciation, and support the development of our mod in the process, then consider "), class_2561.method_43470((String)"buying us a coffee").method_54663(15550926), class_2561.method_43470((String)".")}), class_5348.method_29433((class_5348[])new class_5348[]{class_2561.method_43470((String)"And thanks again for using our mod! We hope it helps you (and your computer.)")}));

    private VideoSettingsScreen(class_437 prevScreen) {
        super((class_2561)class_2561.method_43470((String)"Sodium Renderer Settings"));
        this.prevScreen = prevScreen;
        this.checkPromptTimers();
        ConfigManager.CONFIG.resetAllOptionsFromBindings();
    }

    private void checkPromptTimers() {
        Instant threshold;
        if (PlatformRuntimeInformation.getInstance().isDevelopmentEnvironment()) {
            return;
        }
        SodiumOptions options = SodiumClientMod.options();
        if (options.notifications.hasSeenDonationPrompt) {
            return;
        }
        HashedFingerprint fingerprint = null;
        try {
            fingerprint = HashedFingerprint.loadFromDisk();
        }
        catch (Throwable t) {
            SodiumClientMod.logger().error("Failed to read the fingerprint from disk", t);
        }
        if (fingerprint == null) {
            return;
        }
        Instant now = Instant.now();
        if (now.isAfter(threshold = Instant.ofEpochSecond(fingerprint.timestamp()).plus(3L, ChronoUnit.DAYS))) {
            this.openDonationPrompt(options);
        }
    }

    private void openDonationPrompt(SodiumOptions options) {
        ScreenPrompt prompt = new ScreenPrompt(this, DONATION_PROMPT_MESSAGE, 320, 190, new ScreenPrompt.Action((class_2561)class_2561.method_43470((String)"Buy us a coffee"), this::openDonationPage));
        prompt.method_25365(true);
        options.notifications.hasSeenDonationPrompt = true;
        try {
            SodiumOptions.writeToDisk(options);
        }
        catch (IOException e) {
            SodiumClientMod.logger().error("Failed to update config file", (Throwable)e);
        }
    }

    public static class_437 createScreen(class_437 currentScreen) {
        if (SodiumClientMod.options().isReadOnly()) {
            return new ConfigCorruptedScreen(currentScreen, VideoSettingsScreen::new);
        }
        return new VideoSettingsScreen(currentScreen);
    }

    protected void method_25426() {
        super.method_25426();
        ConfigManager.CONFIG.invalidateGlobalRebuildDependents();
        this.rebuild();
        if (this.prompt != null) {
            this.prompt.init();
        }
    }

    private int ifInsetX(int value) {
        return this.insetX ? value : 0;
    }

    private int ifInsetY(int value) {
        return this.insetY ? value : 0;
    }

    private int ifNotInsetX(int value) {
        return this.insetX ? 0 : value;
    }

    private int ifNotInsetY(int value) {
        return this.insetY ? 0 : value;
    }

    private void rebuild() {
        this.method_37067();
        this.updateScreenDimensions();
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        int topBarHeight = 20;
        this.searchWidget = new SearchWidget(this::onSearchResults, new Dim2i(x, y, w, topBarHeight));
        int topBarClear = topBarHeight + this.ifInsetY(5);
        this.pageList = new PageListWidget(new Dim2i(x, y + topBarClear, 125, h - topBarClear), this);
        this.method_37063(this.pageList);
        boolean stackVertically = false;
        boolean reserveBottomSpace = false;
        int minWidthToStack = 422;
        int maxWidthToStack = minWidthToStack + 130 + 5;
        if (w > minWidthToStack && w < maxWidthToStack) {
            stackVertically = true;
        } else if (w < minWidthToStack) {
            reserveBottomSpace = true;
        }
        this.closeButton = new FlatButtonWidget(new Dim2i(this.getLimitX() - 65 - this.ifNotInsetX(5), this.getLimitY() - (this.ifNotInsetY(5) + 20), 65, 20), (class_2561)class_2561.method_43471((String)"gui.done"), this::method_25419, true, false);
        this.method_37063(this.closeButton);
        if (stackVertically) {
            this.applyButton = new FlatButtonWidget(new Dim2i(this.closeButton.getX(), this.closeButton.getY() - 25, 65, 20), (class_2561)class_2561.method_43471((String)"sodium.options.buttons.apply"), ConfigManager.CONFIG::applyAllOptions, true, false);
            this.undoButton = new FlatButtonWidget(new Dim2i(this.applyButton.getX(), this.applyButton.getY() - 25, 65, 20), (class_2561)class_2561.method_43471((String)"sodium.options.buttons.undo"), this::undoChanges, true, false);
        } else {
            this.applyButton = new FlatButtonWidget(new Dim2i(this.closeButton.getX() - 5 - 65, this.getLimitY() - 25, 65, 20), (class_2561)class_2561.method_43471((String)"sodium.options.buttons.apply"), ConfigManager.CONFIG::applyAllOptions, true, false);
            this.undoButton = new FlatButtonWidget(new Dim2i(this.applyButton.getX() - 5 - 65, this.getLimitY() - 25, 65, 20), (class_2561)class_2561.method_43471((String)"sodium.options.buttons.undo"), this::undoChanges, true, false);
        }
        this.method_37063(this.undoButton);
        this.method_37063(this.applyButton);
        this.donateButton = new DonationButtonWidget(this, this::openDonationPage, this::hideDonationButton);
        this.method_37063(this.searchWidget);
        this.updateSearchWidgetWidth();
        Dim2i optionListDim = new Dim2i(this.pageList.getLimitX(), y + topBarHeight + 5, 222, h - topBarHeight - (reserveBottomSpace ? 30 : 5) - this.ifNotInsetY(5));
        this.optionList = new OptionListWidget(this, optionListDim, this::onSectionFocused);
        this.method_37063(this.optionList);
        int tooltipAreaY = y + topBarHeight + this.ifInsetY(3);
        this.tooltip.setTooltipArea(new Dim2i(this.optionList.getLimitX(), tooltipAreaY, this.getLimitX() - this.optionList.getLimitX() - this.ifNotInsetX(3), this.getLimitY() - tooltipAreaY - this.ifNotInsetY(3)));
    }

    private void updateScreenDimensions() {
        int baseContentWidth = 355;
        int minContentWidth = baseContentWidth + 50 + 100;
        int maxContentWidth = baseContentWidth + 200;
        int maxInterpolatingBorderWidth = 100;
        int widthInterpolationStart = minContentWidth + 25;
        int widthInterpolationEnd = maxContentWidth + maxInterpolatingBorderWidth;
        int contentWidth = this.field_22789;
        this.insetX = false;
        if (this.field_22789 > minContentWidth + 25) {
            if (this.field_22789 < widthInterpolationEnd) {
                float t = (float)(this.field_22789 - widthInterpolationStart) / (float)(widthInterpolationEnd - widthInterpolationStart);
                contentWidth = minContentWidth + (int)(t * (float)(maxContentWidth - minContentWidth));
            } else {
                contentWidth = maxContentWidth;
            }
            this.insetX = true;
        }
        int contentHeight = this.field_22790;
        this.insetY = false;
        if (this.field_22790 > 312 && this.insetX) {
            contentHeight = this.field_22790 - 12;
            this.insetY = true;
        }
        this.dim = new Dim2i((this.field_22789 - contentWidth) / 2, (this.field_22790 - contentHeight) / 2, contentWidth, contentHeight);
    }

    private void onSearchResults(List<Option.OptionNameSource> searchResults) {
        if (searchResults.isEmpty()) {
            this.optionList.clearFilter();
        } else {
            this.optionList.setFilteredOptions(searchResults);
        }
        this.optionList.rebuild(this);
    }

    private void onSectionFocused(Page page) {
        this.pageList.switchSelected(page);
    }

    public void jumpToPage(Page page) {
        if (this.optionList != null) {
            this.optionList.jumpToPage(page);
        }
    }

    private void updateSearchWidgetWidth() {
        this.searchWidget.updateWidgetWidth(this.getWidth() - this.donateButton.getWidth());
    }

    private void hideDonationButton() {
        SodiumOptions options = SodiumClientMod.options();
        options.notifications.hasClearedDonationButton = true;
        try {
            SodiumOptions.writeToDisk(options);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration", e);
        }
        this.donateButton.updateDisplay(this, false);
        this.updateSearchWidgetWidth();
    }

    public void method_25394(@NonNull class_332 graphics, int mouseX, int mouseY, float delta) {
        this.updateControls(mouseX, mouseY);
        super.method_25394(graphics, this.prompt != null ? -1 : mouseX, this.prompt != null ? -1 : mouseY, delta);
        this.tooltip.render(graphics);
        if (this.prompt != null) {
            this.prompt.method_25394(graphics, mouseX, mouseY, delta);
        }
    }

    private void updateControls(int mouseX, int mouseY) {
        boolean hasChanges = ConfigManager.CONFIG.anyOptionChanged();
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        FlatButtonWidget reservedAreaBlocker = hasChanges ? this.undoButton : this.applyButton;
        this.tooltip.setReservedAreaTopLeftCorner(reservedAreaBlocker.getX(), reservedAreaBlocker.getY());
        this.hasPendingChanges = hasChanges;
        ControlElement hovered = null;
        ControlElement focused = null;
        if (mouseX >= this.optionList.getX() && mouseX <= this.optionList.getLimitX() && mouseY >= this.optionList.getY() && mouseY <= this.optionList.getLimitY()) {
            for (ControlElement element : this.optionList.getControls()) {
                if (element.method_25405(mouseX, mouseY)) {
                    hovered = element;
                    break;
                }
                if (!element.method_25370()) continue;
                focused = element;
            }
        }
        ControlElement hoverTarget = hovered != null ? hovered : focused;
        this.tooltip.onControlHover(hoverTarget, mouseX, mouseY);
    }

    private void undoChanges() {
        ConfigManager.CONFIG.resetAllOptionsFromBindings();
    }

    private void openDonationPage() {
        class_156.method_668().method_670("https://caffeinemc.net/donate");
    }

    public boolean method_25404(class_11908 event) {
        if (this.prompt != null && this.prompt.method_25404(event)) {
            return true;
        }
        if (this.searchWidget.method_25404(event)) {
            return true;
        }
        return super.method_25404(event);
    }

    public boolean method_16803(class_11908 event) {
        if (this.prompt == null && !this.searchWidget.isSearching()) {
            if (event.comp_4795() == 80 && (event.comp_4797() & 1) != 0) {
                class_310.method_1551().method_1507((class_437)new class_446(this.prevScreen, class_310.method_1551(), class_310.method_1551().field_1690));
                return true;
            }
            if (event.comp_4795() == 84) {
                this.method_25395(this.searchWidget);
                return true;
            }
        }
        return super.method_16803(event);
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.prompt != null) {
            return this.prompt.method_25402(event, doubleClick);
        }
        if (!super.method_25402(event, doubleClick)) {
            if (!this.searchWidget.method_25370()) {
                this.method_25395(this.searchWidget);
                return true;
            }
            this.method_25395(null);
            return true;
        }
        return true;
    }

    public boolean method_25401(double x, double y, double f, double amount) {
        if (class_310.method_1551().method_74188()) {
            IntegerOption guiScaleOption;
            Object v;
            class_2960 location = class_2960.method_60654((String)"sodium:general.gui_scale");
            Option option = ConfigManager.CONFIG.getOption(location);
            if (option instanceof IntegerOption && (v = (guiScaleOption = (IntegerOption)option).getValidatedValue()) instanceof Integer) {
                int newValue;
                Integer intValue = (Integer)v;
                SteppedValidator range = guiScaleOption.getSteppedValidator();
                int top = range.max() + 1;
                int auto = range.min();
                if (intValue == auto) {
                    intValue = top;
                }
                if ((newValue = Math.clamp((long)(intValue + (int)Math.signum(amount)), auto + 1, top)) != intValue) {
                    if (newValue == top) {
                        newValue = auto;
                    }
                    if (range.isValueValid(newValue)) {
                        guiScaleOption.modifyValue(newValue);
                        ConfigManager.CONFIG.applyOption(location);
                        return true;
                    }
                }
            }
            return false;
        }
        if (this.tooltip.mouseScrolled(x, y, amount)) {
            return true;
        }
        return super.method_25401(x, y, f, amount);
    }

    @Override
    public <T extends class_364 & class_4068> T method_37063(T guiEventListener) {
        return (T)super.method_37063(guiEventListener);
    }

    @Override
    public void method_37066(class_364 guiEventListener) {
        super.method_37066(guiEventListener);
    }

    public <T extends class_364 & class_4068> void setWidgetPresence(T guiEventListener, boolean present) {
        this.method_37066(guiEventListener);
        if (present) {
            this.method_37063(guiEventListener);
        }
    }

    public boolean method_25422() {
        return !this.hasPendingChanges;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.prevScreen);
    }

    public List<? extends class_364> method_25396() {
        return this.prompt == null ? super.method_25396() : this.prompt.getWidgets();
    }

    @Override
    public void setPrompt(@Nullable ScreenPrompt prompt) {
        this.prompt = prompt;
    }

    @Override
    public @Nullable ScreenPrompt getPrompt() {
        return this.prompt;
    }

    @Override
    public Dim2i getDimensions() {
        return this.dim;
    }

    public static int renderIconWithSpacing(class_332 graphics, class_2960 icon, int color, int x, int y, int height, int margin) {
        int iconSize = height - margin * 2;
        class_1044 texture = class_310.method_1551().method_1531().method_4619(icon);
        int w = texture.method_68004().getWidth(0);
        int h = texture.method_68004().getHeight(0);
        y = y + height / 2 - iconSize / 2;
        graphics.method_25293(class_10799.field_56883, icon, x += margin, y, 0.0f, 0.0f, iconSize, iconSize, w, h, w, h, color);
        return margin * 2 + iconSize;
    }
}

