/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.options.control;

import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.config.structure.ExternalButtonOption;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.gui.ColorTheme;
import net.caffeinemc.mods.sodium.client.gui.options.control.AbstractOptionList;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ExternalButtonControl
implements Control {
    public static final class_2561 BASE_BUTTON_TEXT = class_2561.method_43471((String)"sodium.options.open_external_page_button");
    private final ExternalButtonOption option;
    private final Consumer<class_437> currentScreenConsumer;

    public ExternalButtonControl(ExternalButtonOption option, Consumer<class_437> currentScreenConsumer) {
        this.option = option;
        this.currentScreenConsumer = currentScreenConsumer;
    }

    @Override
    public Option getOption() {
        return this.option;
    }

    @Override
    public ControlElement createElement(class_437 screen, AbstractOptionList list, Dim2i dim, ColorTheme theme) {
        return new ExternalButtonControlElement(screen, list, dim, this.option, this.currentScreenConsumer, theme);
    }

    @Override
    public int getMaxWidth() {
        return 65;
    }

    public static class_2561 formatExternalButtonText(boolean enabled, ColorTheme theme) {
        if (enabled) {
            class_5250 enabledText = class_2561.method_43473();
            enabledText.method_10852((class_2561)BASE_BUTTON_TEXT.method_27661().method_27692(class_124.field_1073));
            enabledText.method_10852((class_2561)class_2561.method_43470((String)" >").method_27661().method_27696(class_2583.field_24360.method_36139(theme.theme)));
            return enabledText;
        }
        return BASE_BUTTON_TEXT.method_27661().method_27695(new class_124[]{class_124.field_1055, class_124.field_1080});
    }

    private static class ExternalButtonControlElement
    extends ControlElement {
        private final class_437 screen;
        private final ExternalButtonOption option;
        private final Consumer<class_437> currentScreenConsumer;

        public ExternalButtonControlElement(class_437 screen, AbstractOptionList list, Dim2i dim, ExternalButtonOption option, Consumer<class_437> currentScreenConsumer, ColorTheme theme) {
            super(list, dim, theme);
            this.screen = screen;
            this.option = option;
            this.currentScreenConsumer = currentScreenConsumer;
        }

        @Override
        public Option getOption() {
            return this.option;
        }

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            super.method_25394(graphics, mouseX, mouseY, delta);
            class_2561 buttonText = ExternalButtonControl.formatExternalButtonText(this.option.isEnabled(), this.theme);
            this.drawString(graphics, buttonText, this.getLimitX() - 6 - this.font.method_27525((class_5348)buttonText), this.getCenterY() + -4, -1);
        }

        private void openScreen(class_437 screen) {
            this.currentScreenConsumer.accept(screen);
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (this.option.isEnabled() && event.method_74245() == 0 && this.method_25405(event.comp_4798(), event.comp_4799())) {
                this.openScreen(this.screen);
                this.playClickSound();
                return true;
            }
            return false;
        }

        public boolean method_25404(class_11908 event) {
            if (!this.method_25370()) {
                return false;
            }
            if (event.method_74229()) {
                this.openScreen(this.screen);
                this.playClickSound();
                return true;
            }
            return false;
        }
    }
}

