/*
 * Decompiled with CFR 0.152.
 */
package b100.gui.config;

import b100.fullscreenfix.FullscreenFix;
import b100.gui.GuiButton;
import b100.gui.GuiScreen;
import b100.gui.config.ConfigElement;
import b100.gui.config.ConfigElementListener;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class SaveConfigButton
extends GuiButton
implements ConfigElementListener {
    private final Set<ConfigElement<?>> changedConfigElements = new HashSet();

    public SaveConfigButton(GuiScreen screen) {
        super(screen, FullscreenFix.translate("button.saveAndQuit"));
        this.setActive(false);
    }

    @Override
    public void valueChanged(ConfigElement<?> configElement) {
        if (configElement.isChanged()) {
            this.changedConfigElements.add(configElement);
        } else {
            this.changedConfigElements.remove(configElement);
        }
        this.setActive(this.changedConfigElements.size() > 0);
    }

    public void setActive(boolean active) {
        this.setClickable(active);
    }

    @Override
    public void clickButton() {
        for (ConfigElement<?> configElement : this.changedConfigElements) {
            configElement.save();
        }
        super.clickButton();
    }
}

