/*
 * Decompiled with CFR 0.152.
 */
package link.e4mc;

import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.HexFormat;
import link.e4mc.Agnos;
import link.e4mc.Config;
import link.e4mc.E4mcClient;
import link.e4mc.QuiclimeSession;

public class Doctor {
    public static String doctor() {
        ByteArrayOutputStream baos;
        boolean exceptional;
        HttpRequest request;
        HttpClient httpClient;
        ByteArrayOutputStream baos2;
        StringBuilder result = new StringBuilder();
        result.append("mod sha512sum: ");
        try {
            byte[] bytes = Files.readAllBytes(Agnos.jarPath());
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            byte[] digest = md.digest(bytes);
            result.append(HexFormat.of().formatHex(digest));
        }
        catch (Exception e) {
            result.append("exception during digest:\n");
            baos2 = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream((OutputStream)baos2, true, StandardCharsets.UTF_8));
            result.append(baos2.toString(StandardCharsets.UTF_8));
        }
        result.append("\n");
        result.append("QuiclimeSession recorded exception:\n");
        QuiclimeSession session = E4mcClient.session;
        if (session != null && session.failureCause != null) {
            baos2 = new ByteArrayOutputStream();
            session.failureCause.printStackTrace(new PrintStream((OutputStream)baos2, true, StandardCharsets.UTF_8));
            result.append(baos2.toString(StandardCharsets.UTF_8));
            result.append("\n");
        } else {
            result.append("none recorded.\n");
        }
        result.append("natives CDN test results:\n");
        try {
            HttpClient httpClient2 = HttpClient.newHttpClient();
            HttpRequest request2 = HttpRequest.newBuilder(new URI("https://natives.e4mc.link/doctor-test-target")).build();
            HttpResponse<String> response = httpClient2.send(request2, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            boolean exceptional2 = false;
            if (response.statusCode() != 200) {
                exceptional2 = true;
                result.append("status code was not 200, it was: ");
                result.append(response.statusCode());
                result.append("\n");
            }
            if (!response.body().equals("if you can read this, e4mc natives are available. qmqj8c13nzdr0kd10gihcila")) {
                exceptional2 = true;
                result.append("response was unexpected, got: ");
                result.append(response.body());
                result.append("\n");
            }
            if (!exceptional2) {
                result.append("no issues found.\n");
            }
        }
        catch (Exception e) {
            result.append("exception during request:\n");
            ByteArrayOutputStream baos3 = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream((OutputStream)baos3, true, StandardCharsets.UTF_8));
            result.append(baos3.toString(StandardCharsets.UTF_8));
            result.append("\n");
        }
        result.append("broker API test results:\n");
        QuiclimeSession.BrokerResponse brokerResponse = null;
        try {
            if (((Boolean)Config.INSTANCE.useBroker.value()).booleanValue()) {
                result.append("using broker ");
                result.append((String)Config.INSTANCE.brokerUrl.value());
                result.append("\n");
                httpClient = HttpClient.newHttpClient();
                request = HttpRequest.newBuilder(new URI((String)Config.INSTANCE.brokerUrl.value())).header("Accept", "application/json").build();
                HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                exceptional = false;
                if (response.statusCode() != 200) {
                    exceptional = true;
                    result.append("status code was not 200, it was: ");
                    result.append(response.statusCode());
                    result.append("\n");
                }
                Gson gson = new Gson();
                brokerResponse = (QuiclimeSession.BrokerResponse)gson.fromJson(response.body(), QuiclimeSession.BrokerResponse.class);
                if (!exceptional) {
                    result.append("no issues found.\n");
                }
            } else {
                result.append("not using broker.\n");
                QuiclimeSession.BrokerResponse resp = new QuiclimeSession.BrokerResponse();
                resp.id = "custom";
                resp.host = (String)Config.INSTANCE.relayHost.value();
                resp.port = (Integer)Config.INSTANCE.relayPort.value();
                brokerResponse = resp;
            }
        }
        catch (Exception e) {
            result.append("exception during request:\n");
            baos = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8));
            result.append(baos.toString(StandardCharsets.UTF_8));
            result.append("\n");
        }
        result.append("broker response:\n");
        if (brokerResponse == null) {
            result.append("none successfully received.\n");
        } else {
            result.append(String.format("relay id is %s, host is %s, port is %d.\n", brokerResponse.id, brokerResponse.host, brokerResponse.port));
        }
        result.append("relay HTTP test results:\n");
        if (brokerResponse == null) {
            result.append("no broker response.\n");
        } else if (!brokerResponse.host.endsWith(".e4mc.link")) {
            result.append("host is not standard. not attempting ping.\n");
        } else {
            try {
                httpClient = HttpClient.newHttpClient();
                request = HttpRequest.newBuilder(new URI(String.format("https://%s/ping", brokerResponse.host))).build();
                HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
                exceptional = false;
                if (response.statusCode() != 200) {
                    exceptional = true;
                    result.append("status code was not 200, it was: ");
                    result.append(response.statusCode());
                    result.append("\n");
                }
                if (!response.body().equals("OK")) {
                    exceptional = true;
                    result.append("response was unexpected, got: ");
                    result.append(response.body());
                    result.append("\n");
                }
                if (!exceptional) {
                    result.append("no issues found.\n");
                }
            }
            catch (Exception e) {
                result.append("exception during request:\n");
                baos = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8));
                result.append(baos.toString(StandardCharsets.UTF_8));
                result.append("\n");
            }
        }
        return result.toString();
    }
}

