/*
 * Decompiled with CFR 0.152.
 */
package link.e4mc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import link.e4mc.Agnos;
import link.e4mc.Config;
import link.e4mc.Doctor;
import link.e4mc.Mirror;
import link.e4mc.PoisonPill;
import link.e4mc.QuiclimeSession;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3014;
import net.minecraft.class_3016;
import net.minecraft.class_3086;
import net.minecraft.class_3156;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E4mcClient {
    public static final String MOD_ID = "e4mc_minecraft";
    public static QuiclimeSession session;
    public static final Logger LOGGER;
    public static boolean badurl;

    public static void init() {
        Config.INSTANCE.id();
        try {
            if (!PoisonPill.checkMotw()) {
                badurl = true;
                LOGGER.warn("MotW lists unknown source! Poison pill active!");
            }
        }
        catch (Exception e) {
            LOGGER.warn("MotW check failed!", (Throwable)e);
        }
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        if (((Boolean)Config.INSTANCE.restoreDedicatedCommands.value()).booleanValue() && Agnos.isClient()) {
            class_3014.method_13014(dispatcher);
            class_3016.method_13021(dispatcher);
            class_3086.method_13472(dispatcher);
            class_3156.method_13836(dispatcher);
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"e4mc").requires(src -> {
            if (src.method_9211() == null) {
                return false;
            }
            if (src.method_9211().method_3816()) {
                return src.method_9259(4);
            }
            try {
                return Mirror.isSingleplayerOwner(src.method_9211(), src.method_9207());
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).then(class_2170.method_9247((String)"stop").executes(ctx -> {
            if (session != null && E4mcClient.session.state != QuiclimeSession.State.STOPPED) {
                session.stop();
                Mirror.sendSuccessToSource((class_2168)ctx.getSource(), Mirror.translatable("text.e4mc_minecraft.closeServer", new Object[0]));
            } else {
                Mirror.sendFailureToSource((class_2168)ctx.getSource(), Mirror.translatable("text.e4mc_minecraft.serverAlreadyClosed", new Object[0]));
            }
            return 1;
        }))).then(class_2170.method_9247((String)"doctor").executes(ctx -> {
            Thread thread = new Thread(() -> {
                LOGGER.info("generating e4mc doctor report");
                Mirror.sendSuccessToSource((class_2168)ctx.getSource(), Mirror.translatable("text.e4mc_minecraft.doctor.start", new Object[0]));
                String diag = Doctor.doctor();
                LOGGER.info("e4mc doctor report:\n{}", (Object)diag);
                Mirror.sendSuccessToSource((class_2168)ctx.getSource(), Mirror.literal(diag));
            }, "e4mc_minecraft-doctor");
            thread.setDaemon(true);
            thread.start();
            return 1;
        }))).then(class_2170.method_9247((String)"restart").executes(ctx -> {
            if (session != null && E4mcClient.session.state != QuiclimeSession.State.STARTED) {
                session.stop();
                session = new QuiclimeSession(E4mcClient.session.handler);
                session.startAsync();
            }
            return 1;
        })));
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
        badurl = false;
    }
}

