/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric;

import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.util.Objects;
import me.lucko.spark.fabric.plugin.FabricClientSparkPlugin;
import me.lucko.spark.fabric.plugin.FabricServerSparkPlugin;
import me.lucko.spark.minecraft.SparkMinecraftMod;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_310;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class FabricSparkMod
implements ModInitializer,
SparkMinecraftMod {
    private static FabricSparkMod mod;
    private ModContainer container;
    private Path configDirectory;
    private FabricServerSparkPlugin activeServerPlugin = null;

    public void onInitialize() {
        mod = this;
        FabricLoader loader = FabricLoader.getInstance();
        this.container = (ModContainer)loader.getModContainer("spark").orElseThrow(() -> new IllegalStateException("Unable to get container for spark"));
        this.configDirectory = loader.getConfigDir().resolve("spark");
        ServerLifecycleEvents.SERVER_STARTING.register(this::initializeServer);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopping);
        CommandRegistrationCallback.EVENT.register(this::onServerCommandRegister);
    }

    public static void initializeClient() {
        Objects.requireNonNull(mod, "mod");
        FabricClientSparkPlugin.init(mod, class_310.method_1551());
    }

    public void initializeServer(MinecraftServer server) {
        this.activeServerPlugin = FabricServerSparkPlugin.init(this, server);
    }

    public void onServerStopping(MinecraftServer stoppingServer) {
        if (this.activeServerPlugin != null) {
            this.activeServerPlugin.disable();
            this.activeServerPlugin = null;
        }
    }

    public void onServerCommandRegister(CommandDispatcher<class_2168> dispatcher, class_7157 ctx, class_2170.class_5364 env) {
        if (this.activeServerPlugin != null) {
            this.activeServerPlugin.registerCommands(dispatcher);
        }
    }

    @Override
    public String getVersion() {
        return this.container.getMetadata().getVersion().getFriendlyString();
    }

    @Override
    public Path getConfigDirectory() {
        if (this.configDirectory == null) {
            throw new IllegalStateException("Config directory not set");
        }
        return this.configDirectory;
    }
}

