/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric;

import java.lang.reflect.Method;
import me.lucko.spark.fabric.mixin.ClientLevelAccessor;
import me.lucko.spark.fabric.mixin.LevelAccessor;
import me.lucko.spark.fabric.mixin.PersistentEntitySectionManagerAccessor;
import me.lucko.spark.fabric.mixin.ServerLevelAccessor;
import me.lucko.spark.fabric.mixin.TransientEntitySectionManagerAccessor;
import me.lucko.spark.minecraft.MinecraftWorldInfoProvider;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5570;
import net.minecraft.class_5577;
import net.minecraft.class_5579;
import net.minecraft.class_5582;
import net.minecraft.class_638;
import net.minecraft.server.MinecraftServer;

public class FabricWorldInfoProvider {

    private static final class MoonriseMethods {
        private static Method getEntityCount;

        private MoonriseMethods() {
        }

        private static Method getEntityCountMethod(class_5577<class_1297> getter) {
            if (getEntityCount == null) {
                try {
                    getEntityCount = getter.getClass().getMethod("getEntityCount", new Class[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Cannot find Moonrise getEntityCount method", e);
                }
            }
            return getEntityCount;
        }

        private static int getEntityCount(class_5577<class_1297> getter) {
            try {
                return (Integer)MoonriseMethods.getEntityCountMethod(getter).invoke(getter, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to invoke Moonrise getEntityCount method", e);
            }
        }
    }

    public static final class Client
    extends MinecraftWorldInfoProvider.Client {
        public Client(class_310 client) {
            super(client);
        }

        @Override
        protected int countEntities(class_638 level) {
            if (FabricLoader.getInstance().isModLoaded("moonrise")) {
                return MoonriseMethods.getEntityCount(((LevelAccessor)level).spark$getEntities());
            }
            class_5582<class_1297> entityManager = ((ClientLevelAccessor)level).getEntityStorage();
            class_5570<?> entityIndex = ((TransientEntitySectionManagerAccessor)entityManager).getEntityStorage();
            return entityIndex.method_31756();
        }

        @Override
        protected Iterable<class_1297> getAllEntities(class_638 level) {
            return ((LevelAccessor)level).spark$getEntities().method_31803();
        }
    }

    public static final class Server
    extends MinecraftWorldInfoProvider.Server {
        public Server(MinecraftServer server) {
            super(server);
        }

        @Override
        protected int countEntities(class_3218 level) {
            if (FabricLoader.getInstance().isModLoaded("moonrise")) {
                return MoonriseMethods.getEntityCount(((LevelAccessor)level).spark$getEntities());
            }
            class_5579<class_1297> entityManager = ((ServerLevelAccessor)level).getEntityManager();
            class_5570<?> entityIndex = ((PersistentEntitySectionManagerAccessor)entityManager).getVisibleEntityStorage();
            return entityIndex.method_31756();
        }
    }
}

