/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.handler;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.block.v1.BlockConversionHelper;
import fuzs.puzzleslib.api.event.v1.AddBlockEntityTypeBlocksCallback;
import fuzs.puzzleslib.api.event.v1.RegistryEntryAddedCallback;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jspecify.annotations.Nullable;

public class BlockConversionHandler {
    private static final BiMap<class_2248, class_2248> BLOCK_CONVERSIONS = HashBiMap.create();
    private static final Map<class_2680, class_2680> BLOCK_STATE_CONVERSIONS_CACHE = new MapMaker().weakKeys().weakValues().makeMap();

    public static RegistryEntryAddedCallback<class_2248> onRegistryEntryAdded(Predicate<class_2248> filter, Function<class_4970.class_2251, class_2248> factory, String modId) {
        return (registry, id, block, registrar) -> {
            if (filter.test((class_2248)block)) {
                class_2960 identifier = class_2960.method_60655((String)modId, (String)(id.method_12836() + "/" + id.method_12832()));
                registrar.accept(identifier, () -> {
                    class_4970.class_2251 properties = BlockConversionHelper.copyBlockProperties((class_2248)block, (class_2960)identifier);
                    class_2248 newBlock = (class_2248)factory.apply(properties);
                    BLOCK_CONVERSIONS.put(block, (Object)newBlock);
                    return newBlock;
                });
            }
        };
    }

    public static BiMap<class_2248, class_2248> getBlockConversions() {
        return Maps.unmodifiableBiMap(BLOCK_CONVERSIONS);
    }

    public static AddBlockEntityTypeBlocksCallback onAddBlockEntityTypeBlocks(class_6880.class_6883<? extends class_2591<?>> blockEntityType) {
        return consumer -> {
            for (Map.Entry entry : BLOCK_CONVERSIONS.entrySet()) {
                consumer.accept((class_2591)blockEntityType.comp_349(), (class_2248)entry.getValue());
            }
        };
    }

    public static PlayerInteractEvents.UseBlock onUseBlock(class_6862<class_2248> unalteredBlocks, @Nullable class_3414 soundEvent, BooleanSupplier convertVanillaBlock) {
        return (player, level, interactionHand, hitResult) -> {
            if (!convertVanillaBlock.getAsBoolean()) {
                return EventResultHolder.pass();
            }
            class_2338 blockPos = hitResult.method_17777();
            class_2680 blockState = level.method_8320(blockPos);
            class_2248 block = (class_2248)BLOCK_CONVERSIONS.get((Object)blockState.method_26204());
            if (block != null && !blockState.method_26164(unalteredBlocks)) {
                if (level instanceof class_3218) {
                    level.method_8651(blockPos, false, (class_1297)player);
                    if (soundEvent != null) {
                        level.method_8396(null, blockPos, soundEvent, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.1f + 0.9f);
                    }
                }
                level.method_8652(blockPos, block.method_34725(blockState), 3);
                return EventResultHolder.interrupt((Object)class_1269.field_5812);
            }
            return EventResultHolder.pass();
        };
    }

    public static TagsUpdatedCallback onTagsUpdated(class_6862<class_2248> unalteredBlocks, Predicate<class_2248> filter) {
        return (registries, client) -> {
            for (Map.Entry entry : class_7923.field_41178.method_29722()) {
                Object patt0$temp = entry.getValue();
                if (!(patt0$temp instanceof class_1747)) continue;
                class_1747 blockItem = (class_1747)patt0$temp;
                class_2248 block = blockItem.method_7711();
                BlockConversionHandler.setItemForBlock(filter, blockItem, block);
                BlockConversionHandler.setBlockForItem(unalteredBlocks, blockItem, block);
            }
            BLOCK_CONVERSIONS.forEach(BlockConversionHelper::copyBoundTags);
        };
    }

    private static void setItemForBlock(Predicate<class_2248> filter, class_1747 blockItem, class_2248 block) {
        if (filter.test(block)) {
            BlockConversionHelper.setItemForBlock((class_2248)((class_2248)BLOCK_CONVERSIONS.get((Object)block)), (class_1792)blockItem);
        }
    }

    private static void setBlockForItem(class_6862<class_2248> tagKey, class_1747 blockItem, class_2248 block) {
        class_2248 oldBlock;
        class_2248 newBlock = (class_2248)BLOCK_CONVERSIONS.get((Object)block);
        if (newBlock != null) {
            oldBlock = block;
        } else {
            oldBlock = (class_2248)BLOCK_CONVERSIONS.inverse().get((Object)block);
            if (oldBlock != null) {
                newBlock = block;
            } else {
                return;
            }
        }
        if (oldBlock.method_40142().method_40220(tagKey)) {
            BlockConversionHelper.setBlockForItem((class_1747)blockItem, (class_2248)oldBlock);
        } else {
            BlockConversionHelper.setBlockForItem((class_1747)blockItem, (class_2248)newBlock);
        }
    }

    public static @Nullable class_2680 convertToVanillaBlock(@Nullable class_2680 blockState) {
        return BlockConversionHandler.applyBlockConversion(blockState, true);
    }

    public static @Nullable class_2680 convertFromVanillaBlock(@Nullable class_2680 blockState) {
        return BlockConversionHandler.applyBlockConversion(blockState, false);
    }

    private static @Nullable class_2680 applyBlockConversion(@Nullable class_2680 blockState, boolean inverse) {
        if (blockState != null) {
            return BLOCK_STATE_CONVERSIONS_CACHE.computeIfAbsent(blockState, BlockConversionHandler.applyBlockConversion(inverse));
        }
        return null;
    }

    private static UnaryOperator<class_2680> applyBlockConversion(boolean inverse) {
        return blockState -> {
            BiMap blockConversions;
            BiMap biMap = blockConversions = inverse ? BLOCK_CONVERSIONS.inverse() : BLOCK_CONVERSIONS;
            if (blockState != null && blockConversions.containsKey((Object)blockState.method_26204())) {
                class_2248 block = (class_2248)blockConversions.get((Object)blockState.method_26204());
                return BlockConversionHandler.copyAllProperties(blockState, block.method_9564());
            }
            return blockState;
        };
    }

    private static <T extends Comparable<T>, V extends T> class_2680 copyAllProperties(class_2680 oldBlockState, class_2680 newBlockState) {
        for (Map.Entry entry : oldBlockState.method_11656().entrySet()) {
            newBlockState = (class_2680)newBlockState.method_47968((class_2769)entry.getKey(), (Comparable)entry.getValue());
        }
        return newBlockState;
    }
}

