/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.handler;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.handler.BlockConversionHandler;
import fuzs.easyanvils.network.ClientboundAnvilRepairMessage;
import fuzs.easyanvils.network.ClientboundOpenNameTagEditorMessage;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.api.network.v4.message.Message;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3914;
import net.minecraft.class_3965;
import org.jspecify.annotations.Nullable;

public class ItemInteractionHandler {
    public static EventResultHolder<class_1269> onUseItem(class_1657 player, class_1937 level, class_1268 hand) {
        if (!((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.editNameTagsNoAnvil) {
            return EventResultHolder.pass();
        }
        class_1799 itemInHand = player.method_5998(hand);
        if (player.method_5715() && itemInHand.method_31574(class_1802.field_8448)) {
            MessageSender.broadcast((PlayerSet)PlayerSet.ofEntity((class_1297)player), (Message)new ClientboundOpenNameTagEditorMessage(hand, itemInHand.method_7964()));
            return EventResultHolder.interrupt((Object)InteractionResultHelper.sidedSuccess((boolean)level.method_8608()));
        }
        return EventResultHolder.pass();
    }

    public static EventResultHolder<class_1269> onUseBlock(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        class_2338 pos;
        class_2680 state;
        if (!((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.anvilRepairing) {
            return EventResultHolder.pass();
        }
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31574(class_1802.field_8773) && (state = level.method_8320(pos = hitResult.method_17777())).method_26164(class_3481.field_15486) && ItemInteractionHandler.tryRepairAnvil(level, pos, state)) {
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            return EventResultHolder.interrupt((Object)InteractionResultHelper.sidedSuccess((boolean)level.method_8608()));
        }
        return EventResultHolder.pass();
    }

    public static boolean tryRepairAnvil(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        class_2680 repairedState = ItemInteractionHandler.getRepairedState(blockState);
        if (repairedState != null) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                level.method_8652(blockPos, repairedState, 2);
                MessageSender.broadcast((PlayerSet)PlayerSet.nearPosition((class_2382)blockPos, (class_3218)serverLevel), (Message)new ClientboundAnvilRepairMessage(blockPos, repairedState));
            }
            return true;
        }
        return false;
    }

    private static @Nullable class_2680 getRepairedState(class_2680 blockState) {
        blockState = BlockConversionHandler.convertToVanillaBlock(blockState);
        blockState = ItemInteractionHandler.getVanillaRepairedState(blockState);
        return BlockConversionHandler.convertFromVanillaBlock(blockState);
    }

    private static @Nullable class_2680 getVanillaRepairedState(@Nullable class_2680 blockState) {
        if (blockState != null && blockState.method_27852(class_2246.field_10414)) {
            return (class_2680)class_2246.field_10105.method_9564().method_11657((class_2769)class_2199.field_9883, (Comparable)((class_2350)blockState.method_11654((class_2769)class_2199.field_9883)));
        }
        if (blockState != null && blockState.method_27852(class_2246.field_10105)) {
            return (class_2680)class_2246.field_10535.method_9564().method_11657((class_2769)class_2199.field_9883, (Comparable)((class_2350)blockState.method_11654((class_2769)class_2199.field_9883)));
        }
        return null;
    }

    public static void onTakeAnvilOutputItemStack(class_3914 containerLevelAccess, class_1657 player, boolean onlyRenaming) {
        containerLevelAccess.method_17393((level, blockPos) -> {
            class_2680 blockstate = level.method_8320(blockPos);
            if (!player.method_31549().field_7477 && blockstate.method_26164(class_3481.field_15486) && player.method_59922().method_43057() < ItemInteractionHandler.computeAnvilBreakChance(onlyRenaming)) {
                class_2680 damagedBlockState = class_2199.method_9346((class_2680)blockstate);
                if (damagedBlockState == null) {
                    level.method_8650(blockPos, false);
                    level.method_20290(1029, blockPos, 0);
                } else {
                    level.method_8652(blockPos, damagedBlockState, 2);
                    level.method_20290(1030, blockPos, 0);
                }
            } else {
                level.method_20290(1030, blockPos, 0);
            }
        });
    }

    private static float computeAnvilBreakChance(boolean onlyRenaming) {
        if (((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.riskFreeAnvilRenaming && onlyRenaming) {
            return 0.0f;
        }
        return (float)((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.anvilBreakChance;
    }
}

