/*
 * Decompiled with CFR 0.152.
 */
package visuality.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.class_10758;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1642;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import visuality.VisualityMod;
import visuality.registry.HitParticleRegistry;
import visuality.registry.ShinyArmorRegistry;
import visuality.registry.VisualityParticles;
import visuality.util.ParticleUtils;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Unique
    class_1309 self = (class_1309)class_1309.class.cast((Object)this);
    @Unique
    int ticksDelay = 0;

    @Shadow
    public abstract boolean method_5805();

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"method_5773"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        if (this.method_73183().method_8608() && this.ticksDelay != 0) {
            --this.ticksDelay;
        }
        if (this.method_73183().method_8608() && this.method_5805() && client.field_1724 != null && VisualityMod.config.shinyArmorEnabled) {
            if (client.field_1724.method_5667().equals(this.method_5667())) {
                if (!client.field_1690.method_31044().method_31034()) {
                    this.spawnSparkles();
                }
            } else {
                this.spawnSparkles();
            }
        }
    }

    public boolean method_5643(class_1282 source) {
        class_1297 class_12972;
        if (this.method_73183().method_8608() && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 attacker = (class_1309)class_12972;
            if (this.ticksDelay == 0 && this.method_5805() && VisualityMod.config.hitParticlesEnabled) {
                HitParticleRegistry.ENTRIES.forEach(entry -> {
                    LivingEntityMixin patt0$temp;
                    if (!this.method_5864().equals(entry.entity())) return;
                    this.ticksDelay = 10;
                    class_1799 stack = attacker.method_6047();
                    int count = this.field_5974.method_43048(3);
                    if (stack.method_57353().method_57832(class_9334.field_49636)) {
                        class_9285 data = (class_9285)stack.method_57353().method_58694(class_9334.field_49636);
                        for (class_9285.class_9287 att : data.comp_2393()) {
                            if (!att.comp_2395().equals((Object)class_5134.field_23721)) continue;
                            count = (int)((float)att.comp_2396().comp_2449() * 0.5f);
                        }
                    }
                    if ((patt0$temp = this) instanceof class_1428) {
                        class_1428 chicken = (class_1428)patt0$temp;
                        if (entry.particle().equals((Object)VisualityParticles.FEATHER)) {
                            class_6880 variant = chicken.method_67522();
                            class_2400 particle = VisualityParticles.FEATHER;
                            if (variant.method_40230().isPresent()) {
                                if (((class_5321)variant.method_40230().get()).equals(class_10758.field_56549)) {
                                    particle = VisualityParticles.COLD_FEATHER;
                                }
                                if (((class_5321)variant.method_40230().get()).equals(class_10758.field_56548)) {
                                    particle = VisualityParticles.WARM_FEATHER;
                                }
                            }
                            this.spawnHitParticles((class_2394)particle, count);
                            return;
                        }
                    }
                    this.spawnHitParticles(entry.particle(), count);
                });
            }
        }
        return super.method_5643(source);
    }

    @Unique
    private void spawnHitParticles(class_2394 particle, int count) {
        float height = this.method_17682();
        height = height * 100.0f < 100.0f ? 1.0f : (height += 0.5f);
        for (int i = 0; i <= Math.min(count, 10); ++i) {
            double randomHeight = (double)this.field_5974.method_43048((int)height * 10) / 10.0;
            ParticleUtils.add(this.method_73183(), particle, this.method_23317(), this.method_23318() + 0.2 + randomHeight, this.method_23321());
        }
    }

    @Unique
    private void spawnSparkles() {
        class_1642 zomb;
        class_1309 class_13092 = this.self;
        if (class_13092 instanceof class_1642 && (zomb = (class_1642)class_13092).method_6109()) {
            return;
        }
        if (!this.hasShinyArmor()) {
            return;
        }
        ArrayList heights = Lists.newArrayList();
        if (ShinyArmorRegistry.isShiny(this.self.method_6118(class_1304.field_6166))) {
            heights.add(Float.valueOf(0.25f));
        }
        if (ShinyArmorRegistry.isShiny(this.self.method_6118(class_1304.field_6172))) {
            heights.add(Float.valueOf(0.65f));
        }
        if (ShinyArmorRegistry.isShiny(this.self.method_6118(class_1304.field_6174))) {
            heights.add(Float.valueOf(1.1f));
        }
        if (ShinyArmorRegistry.isShiny(this.self.method_6118(class_1304.field_6169)) && this.self.method_5715()) {
            heights.add(Float.valueOf(1.65f));
        } else if (ShinyArmorRegistry.isShiny(this.self.method_6118(class_1304.field_6169))) {
            heights.add(Float.valueOf(1.85f));
        }
        if (!heights.isEmpty()) {
            float height = ((Float)heights.get(this.field_5974.method_43048(heights.size()))).floatValue();
            if (this.field_5974.method_43048(20 - heights.size() * 2) == 0) {
                double randX = (double)this.field_5974.method_43057() - 0.5;
                double randY = (double)(this.field_5974.method_43057() * 2.0f - 1.0f) / 5.0;
                double randZ = (double)this.field_5974.method_43057() - 0.5;
                ParticleUtils.add(this.method_73183(), (class_2394)VisualityParticles.SPARKLE, this.method_23317() + randX, this.method_23318() + randY + (double)height, this.method_23321() + randZ);
            }
        }
    }

    private boolean hasShinyArmor() {
        if (ShinyArmorRegistry.isShiny(this.self.method_6118(class_1304.field_6166))) {
            return true;
        }
        if (ShinyArmorRegistry.isShiny(this.self.method_6118(class_1304.field_6172))) {
            return true;
        }
        if (ShinyArmorRegistry.isShiny(this.self.method_6118(class_1304.field_6174))) {
            return true;
        }
        return ShinyArmorRegistry.isShiny(this.self.method_6118(class_1304.field_6169));
    }
}

