/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components;

import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;

public class ScrollBarComponent
extends AbstractWidget {
    protected static final int SCROLL_STEP = 6;
    private final ScrollDirection mode;
    private final int contentLength;
    private final int visibleAreaLength;
    private final int maxContentOffset;
    private final Consumer<Integer> offsetChangeListener;
    private final Dim2i extraScrollArea;
    private int offset = 0;
    private boolean isDragging;
    private Dim2i scrollThumb = null;
    private int scrollThumbClickOffset;

    public ScrollBarComponent(Dim2i trackArea, ScrollDirection scrollDirection, int contentLength, int visibleAreaLength, Consumer<Integer> offsetChangeListener) {
        this(trackArea, scrollDirection, contentLength, visibleAreaLength, offsetChangeListener, null);
    }

    public ScrollBarComponent(Dim2i scrollBarArea, ScrollDirection scrollDirection, int contentLength, int visibleAreaLength, Consumer<Integer> offsetChangeListener, Dim2i extraScrollArea) {
        super(scrollBarArea);
        this.mode = scrollDirection;
        this.contentLength = contentLength;
        this.visibleAreaLength = visibleAreaLength;
        this.offsetChangeListener = offsetChangeListener;
        this.maxContentOffset = this.contentLength - this.visibleAreaLength;
        this.extraScrollArea = extraScrollArea;
        this.updateThumbLocation();
    }

    public void updateThumbLocation() {
        int trackSize = this.mode == ScrollDirection.VERTICAL ? this.getHeight() : this.getWidth() - 6;
        int scrollThumbLength = this.visibleAreaLength * trackSize / this.contentLength;
        int maximumScrollThumbOffset = this.visibleAreaLength - scrollThumbLength;
        int scrollThumbOffset = this.offset * maximumScrollThumbOffset / this.maxContentOffset;
        this.scrollThumb = new Dim2i(this.getX() + 2 + (this.mode == ScrollDirection.HORIZONTAL ? scrollThumbOffset : 0), this.getY() + 2 + (this.mode == ScrollDirection.VERTICAL ? scrollThumbOffset : 0), (this.mode == ScrollDirection.VERTICAL ? this.getWidth() : scrollThumbLength) - 4, (this.mode == ScrollDirection.VERTICAL ? scrollThumbLength : this.getHeight()) - 4);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.drawBorder(guiGraphics, this.getX(), this.getY(), this.getLimitX(), this.getLimitY(), -5592406);
        this.drawRect(guiGraphics, this.scrollThumb.x(), this.scrollThumb.y(), this.scrollThumb.getLimitX(), this.scrollThumb.getLimitY(), -5592406);
        if (this.method_25370()) {
            this.drawBorder(guiGraphics, this.getX(), this.getY(), this.getLimitX(), this.getLimitY(), -1);
        }
    }

    public boolean method_25402(class_11909 event, boolean bl) {
        if (this.method_25405(event.comp_4798(), event.comp_4799())) {
            if (this.scrollThumb.containsCursor(event.comp_4798(), event.comp_4799())) {
                this.scrollThumbClickOffset = (int)(this.mode == ScrollDirection.VERTICAL ? event.comp_4799() - (double)this.scrollThumb.getCenterY() : event.comp_4798() - (double)this.scrollThumb.getCenterX());
                this.isDragging = true;
            } else {
                int thumbLength = this.mode == ScrollDirection.VERTICAL ? this.scrollThumb.height() : this.scrollThumb.width();
                int trackLength = this.mode == ScrollDirection.VERTICAL ? this.getHeight() : this.getWidth();
                int value = (int)(((this.mode == ScrollDirection.VERTICAL ? event.comp_4799() - (double)this.getY() : event.comp_4798() - (double)this.getX()) - (double)thumbLength / 2.0) * (double)this.maxContentOffset / (double)(trackLength - thumbLength));
                this.setOffset(value);
                this.isDragging = false;
            }
            return true;
        }
        this.isDragging = false;
        return false;
    }

    public boolean method_25406(class_11909 event) {
        if (event.method_74245() == 0) {
            this.isDragging = false;
        }
        return false;
    }

    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        if (this.isDragging) {
            int thumbLength = this.mode == ScrollDirection.VERTICAL ? this.scrollThumb.height() : this.scrollThumb.width();
            int trackLength = this.mode == ScrollDirection.VERTICAL ? this.getHeight() : this.getWidth();
            int value = (int)(((this.mode == ScrollDirection.VERTICAL ? event.comp_4799() : event.comp_4798()) - (double)this.scrollThumbClickOffset - (double)(this.mode == ScrollDirection.VERTICAL ? this.getY() : this.getX()) - (double)thumbLength / 2.0) * (double)this.maxContentOffset / (double)(trackLength - thumbLength));
            this.setOffset(value);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.method_25405(mouseX, mouseY) || this.extraScrollArea != null && this.extraScrollArea.containsCursor(mouseX, mouseY)) {
            this.setOffset(this.offset - (int)verticalAmount * 6);
            return true;
        }
        return false;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int value) {
        this.offset = class_3532.method_15340((int)value, (int)0, (int)this.maxContentOffset);
        this.updateThumbLocation();
        this.offsetChangeListener.accept(this.offset);
    }

    @NotNull
    public class_8030 method_48202() {
        return new class_8030(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public boolean method_25404(class_11908 event) {
        int newOffset;
        if (!this.method_25370()) {
            return false;
        }
        switch (event.comp_4795()) {
            case 265: {
                int n = this.getOffset() - 6;
                break;
            }
            case 264: {
                int n = this.getOffset() + 6;
                break;
            }
            case 263: {
                int n;
                if (this.mode == ScrollDirection.HORIZONTAL) {
                    n = this.getOffset() - 6;
                    break;
                }
                n = this.getOffset();
                break;
            }
            case 262: {
                int n;
                if (this.mode == ScrollDirection.HORIZONTAL) {
                    n = this.getOffset() + 6;
                    break;
                }
                n = this.getOffset();
                break;
            }
            default: {
                int n = newOffset = this.getOffset();
            }
        }
        if (newOffset != this.getOffset()) {
            this.setOffset(newOffset);
            return true;
        }
        return false;
    }

    public static enum ScrollDirection {
        HORIZONTAL,
        VERTICAL;

    }
}

