/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config.gui;

import com.google.common.util.concurrent.AtomicDouble;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.class_1041;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.xolt.freecam.Freecam;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DoubleSliderEntry
extends TooltipListEntry<Double> {
    private final Slider sliderWidget;
    private final class_4185 resetButton;
    private final AtomicDouble value;
    private final double original;
    private final int precision;
    private final double minimum;
    private final double maximum;
    private final Supplier<Double> defaultValue;
    private final List<class_339> widgets;

    DoubleSliderEntry(class_2561 fieldName, int precision, double minimum, double maximum, double value, class_2561 resetText, Supplier<Double> defaultValue, @Nullable Consumer<Double> save) {
        super(fieldName, null);
        this.value = new AtomicDouble(value);
        this.original = value;
        this.defaultValue = defaultValue;
        this.maximum = maximum;
        this.minimum = minimum;
        this.precision = precision;
        this.saveCallback = save;
        this.sliderWidget = new Slider(0, 0, 152, 20, (this.value.get() - minimum) / (maximum - minimum));
        this.sliderWidget.method_25346();
        this.resetButton = class_4185.method_46430((class_2561)resetText, widget -> this.setValue(this.defaultValue.get())).method_46432(Freecam.MC.field_1772.method_27525((class_5348)resetText) + 6).method_46431();
        this.widgets = List.of(this.sliderWidget, this.resetButton);
    }

    public Double getValue() {
        return this.value.get();
    }

    public void setValue(double value) {
        double clamped = class_3532.method_15350((double)value, (double)this.minimum, (double)this.maximum);
        this.value.set(clamped);
        this.sliderWidget.method_25347((clamped - this.minimum) / (this.maximum - this.minimum));
        this.sliderWidget.method_25346();
    }

    public boolean isEdited() {
        return super.isEdited() || this.getValue() != this.original;
    }

    public Optional<Double> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue).map(Supplier::get);
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.widgets;
    }

    public List<? extends class_6379> narratables() {
        return this.widgets;
    }

    public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        class_1041 window = Freecam.MC.method_22683();
        this.resetButton.field_22763 = this.isEditable() && this.getDefaultValue().isPresent() && this.defaultValue.get().doubleValue() != this.value.get();
        this.resetButton.method_46419(y);
        this.sliderWidget.field_22763 = this.isEditable();
        this.sliderWidget.method_46419(y);
        class_2561 name = this.getDisplayedFieldName();
        if (Freecam.MC.field_1772.method_1726()) {
            graphics.method_35720(Freecam.MC.field_1772, name.method_30937(), window.method_4486() - x - Freecam.MC.field_1772.method_27525((class_5348)name), y + 6, this.getPreferredTextColor());
            this.resetButton.method_46421(x);
            this.sliderWidget.method_46421(x + this.resetButton.method_25368() + 1);
        } else {
            graphics.method_35720(Freecam.MC.field_1772, name.method_30937(), x, y + 6, this.getPreferredTextColor());
            this.resetButton.method_46421(x + entryWidth - this.resetButton.method_25368());
            this.sliderWidget.method_46421(x + entryWidth - 150);
        }
        this.sliderWidget.method_25358(150 - this.resetButton.method_25368() - 2);
        this.resetButton.method_25394(graphics, mouseX, mouseY, delta);
        this.sliderWidget.method_25394(graphics, mouseX, mouseY, delta);
    }

    private final class Slider
    extends class_357 {
        private Slider(int x, int y, int width, int height, double value) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), value);
        }

        public void method_25346() {
            NumberFormat fmt = DecimalFormat.getInstance();
            fmt.setMinimumIntegerDigits(1);
            fmt.setMinimumFractionDigits(DoubleSliderEntry.this.precision);
            fmt.setMaximumFractionDigits(DoubleSliderEntry.this.precision);
            this.method_25355((class_2561)class_2561.method_43470((String)("Value: " + fmt.format(DoubleSliderEntry.this.value.get()))));
        }

        protected void method_25344() {
            double rounded = BigDecimal.valueOf(DoubleSliderEntry.this.minimum + (DoubleSliderEntry.this.maximum - DoubleSliderEntry.this.minimum) * this.field_22753).setScale(DoubleSliderEntry.this.precision, RoundingMode.HALF_UP).doubleValue();
            DoubleSliderEntry.this.value.set(rounded);
        }

        public boolean method_25404(class_11908 event) {
            return DoubleSliderEntry.this.isEditable() && super.method_25404(event);
        }

        public boolean method_25403(class_11909 event, double double_3, double double_4) {
            return DoubleSliderEntry.this.isEditable() && super.method_25403(event, double_3, double_4);
        }

        public void method_25347(double value) {
            super.method_25347(value);
        }
    }
}

