/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.client.animation;

import com.zigythebird.playeranim.animation.PlayerAnimResources;
import com.zigythebird.playeranim.animation.PlayerAnimationController;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.AdjustmentModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonMode;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.Optional;
import net.bettercombat.client.animation.PoseData;
import net.minecraft.class_11890;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class PoseAnimationStack
extends PlayerAnimationController {
    public static final class_2960 MAIN_HAND_BODY_ID = class_2960.method_60655((String)"bettercombat", (String)"pose_main_hand_body");
    public static final class_2960 MAIN_HAND_ITEM_ID = class_2960.method_60655((String)"bettercombat", (String)"pose_main_hand_item");
    public static final class_2960 OFF_HAND_BODY_ID = class_2960.method_60655((String)"bettercombat", (String)"pose_off_hand_body");
    public static final class_2960 OFF_HAND_ITEM_ID = class_2960.method_60655((String)"bettercombat", (String)"pose_off_hand_item");
    public final MirrorModifier mirror = new MirrorModifier();
    public boolean lastAnimationUsesBodyChannel = false;
    private final boolean isMainHand;
    private final boolean isBodyChannel;
    private PoseData lastPose;

    public PoseAnimationStack(class_11890 player, AnimationController.AnimationStateHandler animationHandler, boolean isBodyChannel, boolean isMainHand) {
        super(player, animationHandler);
        this.isMainHand = isMainHand;
        this.isBodyChannel = isBodyChannel;
        this.postInit();
    }

    private void postInit() {
        this.addModifier((AbstractModifier)this.mirror, 0);
        if (this.isMainHand && this.isBodyChannel) {
            this.addModifierLast((AbstractModifier)this.createPoseAdjustment());
        }
        this.firstPersonMode = controller -> FirstPersonMode.DISABLED;
    }

    public void setPose(@Nullable String animationId, boolean isLeftHanded) {
        boolean mirror = isLeftHanded;
        if (!this.isMainHand) {
            mirror = !mirror;
        }
        PoseData newPoseData = PoseData.from(animationId, mirror);
        if (this.lastPose != null && newPoseData.equals(this.lastPose)) {
            return;
        }
        if (animationId == null) {
            this.stopTriggeredAnimation();
            this.lastAnimationUsesBodyChannel = false;
        } else {
            Animation animation = PlayerAnimResources.getAnimation((class_2960)class_2960.method_60654((String)animationId));
            this.mirror.enabled = mirror;
            this.triggerAnimation(animation);
        }
        this.lastPose = newPoseData;
    }

    private AdjustmentModifier createPoseAdjustment() {
        return new AdjustmentModifier((partName, data) -> {
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            class_11890 player = this.getAvatar();
            if (!data.isFirstPersonPass()) {
                if (PoseAnimationStack.isArm(partName)) {
                    if (player.method_18276()) {
                        offsetY -= 3.0f;
                    }
                } else {
                    return Optional.empty();
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    private static boolean isArm(String partName) {
        return partName.equals("right_arm") || partName.equals("left_arm");
    }
}

