/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.client.animation;

import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.layered.modifier.SpeedModifier;
import java.util.List;

public class TransmissionSpeedModifier
extends SpeedModifier {
    private float elapsed = 0.0f;
    public List<Gear> gears = List.of();

    public TransmissionSpeedModifier(float speed) {
        super(speed);
    }

    public void set(float speed, List<Gear> gears) {
        this.speed = speed;
        this.gears = gears;
        this.elapsed = 0.0f;
    }

    private float elapsed(float delta) {
        return this.elapsed + delta;
    }

    public void tick(AnimationData state) {
        super.tick(state);
        this.elapsed += 1.0f;
    }

    public void setupAnim(AnimationData state) {
        float tickDelta = state.getPartialTick();
        float time = this.elapsed(tickDelta);
        for (Gear gear : this.gears) {
            if (!(time > gear.time)) continue;
            this.speed = gear.speed();
        }
        super.setupAnim(state);
    }

    public record Gear(float time, float speed) {
    }
}

