/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.client.particle;

import net.bettercombat.api.fx.Color;
import net.bettercombat.particle.BetterCombatParticles;
import net.bettercombat.particle.SlashParticleEffect;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11944;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_761;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class SlashParticle
extends class_3940 {
    private final class_4002 spriteProvider;
    public final float modelOffset;
    private final float pitch;
    private final float yaw;
    private final float localYaw;
    private final float roll;
    private final boolean light;

    public SlashParticle(class_638 world, double x, double y, double z, float scale, float pitch, float yaw, float localYaw, float roll, boolean light, long color_rgba, class_4002 spriteProvider) {
        super(world, x, y, z, 0.0, 0.0, 0.0, spriteProvider.method_74304());
        this.spriteProvider = spriteProvider;
        this.light = light;
        this.pitch = pitch;
        this.yaw = yaw;
        this.roll = roll;
        this.localYaw = localYaw;
        Color color = Color.fromRGBA(color_rgba);
        this.method_74305(color.red(), color.green(), color.blue());
        this.field_62636 = color.alpha();
        this.field_3847 = 6;
        this.modelOffset = this.setModelOffset();
        this.field_17867 = scale;
        this.method_74306(spriteProvider);
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        } else {
            this.method_74306(this.spriteProvider);
        }
    }

    protected int method_3068(float tint) {
        class_2338 blockPos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        if (this.light) {
            return 0xF000F0;
        }
        return this.field_3851.method_22340(blockPos) ? class_761.method_23794((class_1920)this.field_3851, (class_2338)blockPos) : 0;
    }

    public class_703 method_3087(float scale) {
        this.field_17867 = scale;
        return super.method_3087(scale);
    }

    protected class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62641;
    }

    public float setModelOffset() {
        return 0.0f;
    }

    public void method_3074(class_11944 submittable, class_4184 camera, float tickDelta) {
        class_243 cameraPos = camera.method_71156();
        float x = (float)(this.field_3858 - cameraPos.method_10216());
        float y = (float)(this.field_3838 - cameraPos.method_10214());
        float z = (float)(this.field_3856 - cameraPos.method_10215());
        float size = this.method_18132(tickDelta);
        Quaternionf rotation = new Quaternionf();
        Matrix4f rotationMatrix = new Matrix4f();
        rotationMatrix.identity();
        rotationMatrix.rotateY((float)Math.toRadians(-this.yaw));
        rotationMatrix.rotateX((float)Math.toRadians(this.pitch + 90.0f));
        rotationMatrix.rotateY((float)Math.toRadians(this.roll));
        rotationMatrix.rotateZ((float)Math.toRadians(this.localYaw));
        rotation.setFromNormalized((Matrix4fc)rotationMatrix);
        float rotationX = rotation.x;
        float rotationY = rotation.y;
        float rotationZ = rotation.z;
        float rotationW = rotation.w;
        float minU = this.method_18133();
        float maxU = this.method_18134();
        float minV = this.method_18135();
        float maxV = this.method_18136();
        int color = class_9848.method_61318((float)this.field_62636, (float)this.field_62633, (float)this.field_62634, (float)this.field_62635);
        int brightness = this.method_3068(tickDelta);
        submittable.method_74323(this.method_74255(), x, y += this.modelOffset, z, rotationX, rotationY, rotationZ, rotationW, size, maxU, minU, minV, maxV, color, brightness);
        Quaternionf backRotation = new Quaternionf().rotateY((float)Math.PI);
        rotation.mul((Quaternionfc)backRotation);
        rotationX = rotation.x;
        rotationY = rotation.y;
        rotationZ = rotation.z;
        rotationW = rotation.w;
        submittable.method_74323(this.method_74255(), x, y, z, rotationX, rotationY, rotationZ, rotationW, size, minU, maxU, minV, maxV, color, brightness);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Provider
    implements class_707<SlashParticleEffect> {
        private final class_4002 spriteProvider;
        private final BetterCombatParticles.StaticParams params;

        public Provider(class_4002 spriteProvider, BetterCombatParticles.StaticParams params) {
            this.spriteProvider = spriteProvider;
            this.params = params;
        }

        @Nullable
        public class_703 createParticle(SlashParticleEffect settings, class_638 clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ, class_5819 random) {
            return new SlashParticle(clientWorld, x, y, z, settings.getScale(), settings.getPitch(), settings.getYaw(), settings.getLocalYaw(), settings.getRoll(), settings.getLight(), settings.getColorRGBA(), this.spriteProvider);
        }
    }
}

